%feature("docstring") OT::KFold
"K-fold.

Parameters
----------
k : positive integer
    Number of folds in which the sample is split. If not provided, default is
    :math:`k = 10`.

See also
--------
FittingAlgorithm, CorrectedLeaveOneOut

Notes
-----
KFold inherits from :class:`~openturns.FittingAlgorithm`.

Examples
--------
>>> import openturns as ot
>>> size = 100
>>> xuniform = ot.Uniform(0.9, 1.1)
>>> x = xuniform.getSample(size)
>>> yuniform = ot.Uniform(1.9, 2.1)
>>> y = yuniform.getSample(size)
>>> w = [1.0] * size
>>> f = ot.SymbolicFunction(['x'], ['2.0 * x'])
>>> basis = [f]
>>> indices = [0]
>>> fittingAlgo = ot.KFold()
>>> result = fittingAlgo.run(x, y, w, basis, indices)
"

// ---------------------------------------------------------------------

%feature("docstring") OT::KFold::getK
"Accessor to the number of folds.

Returns
-------
k : int
    Number of folds in which the sample is split."

// ---------------------------------------------------------------------

%feature("docstring") OT::KFold::setK
"Accessor to the number of folds.

Parameters
----------
k : int
    Number of folds in which the sample is split."
