%feature("docstring") OT::ProfileLikelihoodResult
"Distribution factory result for profile likelihood estimation.

This  class provides all the results obtained after a profile likelihood estimation with respect to the
parameter :math:`\\vect{\\theta}^{(1)}`: refer to :meth:`~openturns.HypothesisTest.LikelihoodRatioTest`.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    Parent distribution at optimal parameter :math:`(\\hat{\\vect{\\theta}}^{(1)}, \\hat{\\vect{\\theta}}^{(2)})`.
parameterDistribution : :class:`~openturns.Distribution`
    Asymptotic distribution of :math:`(\\hat{\\vect{\\theta}}^{(1)}, \\hat{\\vect{\\theta}}^{(2)})`.
logLikelihood : float
    Maximum profile log-likelihood.
profileLikelihood : :class:`~openturns.Function`
    Profile log-likelihood function with respect to the scalar parameter :math:`\\theta^{(1)}`.
parameter : float
    Estimator of :math:`\\vect{\\theta}^{(1)}`.

See also
--------
GeneralizedExtremeValueFactory"

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::getParameterDistribution
"Distribution of :math:`(\\vect{\\theta}^{(1)}, \\vect{\\theta}^{(2)})` accessor.

Returns
-------
parameterDistribution : :class:`~openturns.Distribution`
    Estimator distribution of :math:`(\\vect{\\theta}^{(1)}, \\vect{\\theta}^{(2)})`."

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::setConfidenceLevel
"Confidence level accessor.

Parameters
----------
level : float
    The confidence level :math:`(1-\\alpha)`."

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::getConfidenceLevel
"Confidence level accessor.

Returns
-------
level : float
    The confidence level :math:`(1-\\alpha)`."

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::getParameter
"Estimator of :math:`\\vect{\\theta}^{(1)}`.

Returns
-------
parameter : float
    Estimator of :math:`\\vect{\\theta}^{(1)}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::getParameterConfidenceInterval
"Confidence interval accessor.

Returns
-------
ci : :class:`~openturns.Interval`
    Confidence interval of :math:`\\vect{\\theta}^{(1)}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::getProfileLikelihoodFunction
"Profile log-likelihood function accessor.

Returns
-------
ll : :class:`~openturns.Function`
    Profile log-likelihood function with respect to :math:`\\vect{\\theta}^{(1)}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::ProfileLikelihoodResult::drawProfileLikelihoodFunction
"Draw the profile likelihood graph with respect to the scalar parameter :math:`\\theta^{(1)}`.

If the parameter :math:`\\theta^{(1)}` is scalar, the graph of the profile log-likelihood: :math:`\\theta^{(1)} \\mapsto \\ell_p(\\theta^{(1)})` provides:

- the estimator :math:`\\hat{\\theta}^{(1)}` of  :math:`\\theta^{(1)}` that maximizes the log-profile likelihood,
- the :math:`(1-\\alpha)`-confidence interval of :math:`\\theta^{(1)}` built from the profile deviance statistics :math:`\\mathcal{D}_p (\\theta^{(1)})`.

Returns
-------
graph : :class:`~openturns.Graph`
    Profile likelihood graph with respect to the scalar parameter :math:`\\theta^{(1)}`."
