# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Weighted designs of experiments."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _weightedexperiment
else:
    import _weightedexperiment

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _weightedexperiment.delete_SwigPyIterator

    def value(self):
        return _weightedexperiment.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _weightedexperiment.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _weightedexperiment.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _weightedexperiment.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _weightedexperiment.SwigPyIterator_equal(self, x)

    def copy(self):
        return _weightedexperiment.SwigPyIterator_copy(self)

    def next(self):
        return _weightedexperiment.SwigPyIterator_next(self)

    def __next__(self):
        return _weightedexperiment.SwigPyIterator___next__(self)

    def previous(self):
        return _weightedexperiment.SwigPyIterator_previous(self)

    def advance(self, n):
        return _weightedexperiment.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _weightedexperiment.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _weightedexperiment.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _weightedexperiment.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _weightedexperiment.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _weightedexperiment.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _weightedexperiment.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _weightedexperiment:
_weightedexperiment.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class WeightedExperimentImplementation(openturns.experiment.ExperimentImplementation):
    r"""
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` used to generate the set of input data.
    size : positive int
        Number :math:`\sampleSize` of points that will be generated in the experiment.

    See also
    --------
    openturns.experimental.ExperimentIntegration

    Notes
    -----
    This class is used to generate nodes and their associated weights
    to approximate the weighted integral of a physical model with respect
    to a distribution (see [sullivan2015]_ chapter 9 page 165).

    Let :math:`\model : \physicalInputSpace \rightarrow \physicalOutputSpace` 
    be a function where :math:`\physicalInputSpace \subseteq \Rset^{\inputDim}` 
    is the input space and :math:`\physicalOutputSpace \subseteq \Rset^{\outputDim}`
    is the output space.
    Let :math:`\inputRV` be a random vector with dimension :math:`\outputDim`. 
    We are interested in the expected value of the physical model:

    .. math::

        \Expect{ \model(\inputRV)}
        = \int_{\physicalInputSpace} \model(\inputReal) 
        d\inputMeasure(\inputReal)

    where :math:`\inputMeasure` is the distribution of the input random vector.
    If the input has a probability density function, then:

    .. math::

        \Expect{ \model(\inputRV)}
        = \int_{\physicalInputSpace} \model(\inputReal) 
        \inputProbabilityDensityFunction(\inputReal) d\inputReal

    where :math:`\inputProbabilityDensityFunction` is the probability density 
    function of the input random vector.

    The class computes the weights :math:`\{w_i \in \Rset\}_{i = 1, ..., \sampleSize}`
    and the nodes :math:`\{\inputReal_i \in \Rset^{\inputDim}\}_{i = 1, ..., \sampleSize}`
    such that 

    .. math::

        \Expect{ \model(\inputRV)}
        \approx \sum_{i = 1}^\sampleSize w_i \model\left(\inputReal_i\right)

    By default, all the weights are equal to :math:`w_i = \frac{1}{\sampleSize}`.
    Some quadrature rules e.g. the tensorised Gauss product rule guarantee 
    that all nodes are non negative, but not all rules have that 
    property.

    A `WeightedExperiment` object can be created only through its derived classes
    which are in three groups:

    1. The random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       e.g. 
       :class:`Monte Carlo <openturns.MonteCarloExperiment>`.
       In this case, the value returned by :meth:`~openturns.WeightedExperiment.isRandom()` is `True`.

    2. The :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>` e.g. 
       :class:`~openturns.SobolSequence`.
       In this case, the value returned by :meth:`~openturns.WeightedExperiment.isRandom()` is `False`.

    3. The deterministic patterns or *quadrature rules* e.g.
       :class:`Gauss product <openturns.GaussProductExperiment>`.
       In this case, the value returned by :meth:`~openturns.WeightedExperiment.isRandom()` is `False`.

    In order to estimate the expectation of the model using the nodes and weights,
    we suggest to use the :class:`~openturns.experimental.ExperimentIntegration` class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperimentImplementation_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.WeightedExperimentImplementation___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getDistribution(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setSize(self, size)

    def getSize(self):
        r"""
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getSize(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.WeightedExperimentImplementation_hasUniformWeights(self)

    def generate(self):
        r"""
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\inputReal_i)_{i = 1, ..., \sampleSize}` 
            of the design of experiments. 
            The sampling method is defined by the type of the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generate(self)

    def generateWithWeights(self, weights):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generateWithWeights(self, weights)

    def isRandom(self):
        r"""
        Accessor to the randomness of quadrature.

        Parameters
        ----------
        isRandom : bool
            Is true if the design of experiments is random.
            Otherwise, the design of experiment is assumed to be deterministic.
        """
        return _weightedexperiment.WeightedExperimentImplementation_isRandom(self)

    def __init__(self, *args):
        _weightedexperiment.WeightedExperimentImplementation_swiginit(self, _weightedexperiment.new_WeightedExperimentImplementation(*args))
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementation

# Register WeightedExperimentImplementation in _weightedexperiment:
_weightedexperiment.WeightedExperimentImplementation_swigregister(WeightedExperimentImplementation)
class _WeightedExperimentImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject_swiginit(self, _weightedexperiment.new__WeightedExperimentImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete__WeightedExperimentImplementationTypedInterfaceObject

# Register _WeightedExperimentImplementationTypedInterfaceObject in _weightedexperiment:
_weightedexperiment._WeightedExperimentImplementationTypedInterfaceObject_swigregister(_WeightedExperimentImplementationTypedInterfaceObject)
class WeightedExperimentCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _weightedexperiment.WeightedExperimentCollection_clear(self)

    def __len__(self):
        return _weightedexperiment.WeightedExperimentCollection___len__(self)

    def __eq__(self, rhs):
        return _weightedexperiment.WeightedExperimentCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _weightedexperiment.WeightedExperimentCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _weightedexperiment.WeightedExperimentCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _weightedexperiment.WeightedExperimentCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _weightedexperiment.WeightedExperimentCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _weightedexperiment.WeightedExperimentCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _weightedexperiment.WeightedExperimentCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _weightedexperiment.WeightedExperimentCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _weightedexperiment.WeightedExperimentCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _weightedexperiment.WeightedExperimentCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _weightedexperiment.WeightedExperimentCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _weightedexperiment.WeightedExperimentCollection_find(self, val)

    def __repr__(self):
        return _weightedexperiment.WeightedExperimentCollection___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.WeightedExperimentCollection___str__(self, *args)

    def __init__(self, *args):
        _weightedexperiment.WeightedExperimentCollection_swiginit(self, _weightedexperiment.new_WeightedExperimentCollection(*args))

# Register WeightedExperimentCollection in _weightedexperiment:
_weightedexperiment.WeightedExperimentCollection_swigregister(WeightedExperimentCollection)
class WeightedExperiment(_WeightedExperimentImplementationTypedInterfaceObject):
    r"""
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` used to generate the set of input data.
    size : positive int
        Number :math:`\sampleSize` of points that will be generated in the experiment.

    See also
    --------
    openturns.experimental.ExperimentIntegration

    Notes
    -----
    This class is used to generate nodes and their associated weights
    to approximate the weighted integral of a physical model with respect
    to a distribution (see [sullivan2015]_ chapter 9 page 165).

    Let :math:`\model : \physicalInputSpace \rightarrow \physicalOutputSpace` 
    be a function where :math:`\physicalInputSpace \subseteq \Rset^{\inputDim}` 
    is the input space and :math:`\physicalOutputSpace \subseteq \Rset^{\outputDim}`
    is the output space.
    Let :math:`\inputRV` be a random vector with dimension :math:`\outputDim`. 
    We are interested in the expected value of the physical model:

    .. math::

        \Expect{ \model(\inputRV)}
        = \int_{\physicalInputSpace} \model(\inputReal) 
        d\inputMeasure(\inputReal)

    where :math:`\inputMeasure` is the distribution of the input random vector.
    If the input has a probability density function, then:

    .. math::

        \Expect{ \model(\inputRV)}
        = \int_{\physicalInputSpace} \model(\inputReal) 
        \inputProbabilityDensityFunction(\inputReal) d\inputReal

    where :math:`\inputProbabilityDensityFunction` is the probability density 
    function of the input random vector.

    The class computes the weights :math:`\{w_i \in \Rset\}_{i = 1, ..., \sampleSize}`
    and the nodes :math:`\{\inputReal_i \in \Rset^{\inputDim}\}_{i = 1, ..., \sampleSize}`
    such that 

    .. math::

        \Expect{ \model(\inputRV)}
        \approx \sum_{i = 1}^\sampleSize w_i \model\left(\inputReal_i\right)

    By default, all the weights are equal to :math:`w_i = \frac{1}{\sampleSize}`.
    Some quadrature rules e.g. the tensorised Gauss product rule guarantee 
    that all nodes are non negative, but not all rules have that 
    property.

    A `WeightedExperiment` object can be created only through its derived classes
    which are in three groups:

    1. The random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       e.g. 
       :class:`Monte Carlo <openturns.MonteCarloExperiment>`.
       In this case, the value returned by :meth:`~openturns.WeightedExperiment.isRandom()` is `True`.

    2. The :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>` e.g. 
       :class:`~openturns.SobolSequence`.
       In this case, the value returned by :meth:`~openturns.WeightedExperiment.isRandom()` is `False`.

    3. The deterministic patterns or *quadrature rules* e.g.
       :class:`Gauss product <openturns.GaussProductExperiment>`.
       In this case, the value returned by :meth:`~openturns.WeightedExperiment.isRandom()` is `False`.

    In order to estimate the expectation of the model using the nodes and weights,
    we suggest to use the :class:`~openturns.experimental.ExperimentIntegration` class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.WeightedExperiment___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.WeightedExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.WeightedExperiment_getDistribution(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_setSize(self, size)

    def getSize(self):
        r"""
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_getSize(self)

    def generate(self):
        r"""
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\inputReal_i)_{i = 1, ..., \sampleSize}` 
            of the design of experiments. 
            The sampling method is defined by the type of the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperiment_generate(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperiment_generateWithWeights(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.WeightedExperiment_hasUniformWeights(self)

    def isRandom(self):
        r"""
        Accessor to the randomness of quadrature.

        Parameters
        ----------
        isRandom : bool
            Is true if the design of experiments is random.
            Otherwise, the design of experiment is assumed to be deterministic.
        """
        return _weightedexperiment.WeightedExperiment_isRandom(self)

    def __init__(self, *args):
        _weightedexperiment.WeightedExperiment_swiginit(self, _weightedexperiment.new_WeightedExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperiment

# Register WeightedExperiment in _weightedexperiment:
_weightedexperiment.WeightedExperiment_swigregister(WeightedExperiment)
class BootstrapExperiment(WeightedExperimentImplementation):
    r"""
    Bootstrap experiment.

    Parameters
    ----------
    sample : 2-d sequence of float
        Points to defined a :class:`~openturns.UserDefined` distribution
        :math:`\mu`.

    Notes
    -----
    BootstrapExperiment is a random weighted design of experiments.
    Calling the :class:`BootstrapExperiment` constructor is equivalent to calling the
    :class:`~openturns.WeightedExperiment` constructor as follows:

    ``WeightedExperiment(UserDefined(sample), sample.getSize())``

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> experiment = ot.BootstrapExperiment(sample)
    >>> print(experiment.generate())
        [ v0 v1 ]
    0 : [ 4  5  ]
    1 : [ 1  2  ]
    2 : [ 1  2  ]
    3 : [ 1  2  ]
    4 : [ 2  3  ]
    >>> print(experiment.getDistribution())
    UserDefined({x = [0,1], p = 0.2}, {x = [1,2], p = 0.2}, {x = [2,3], p = 0.2}, {x = [3,4], p = 0.2}, {x = [4,5], p = 0.2})
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.BootstrapExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.BootstrapExperiment___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.BootstrapExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.BootstrapExperiment_getDistribution(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.BootstrapExperiment_generateWithWeights(self)

    @staticmethod
    def GenerateSelection(size, length):
        r"""
        Generate a list of indices of points with replacement.

        Parameters
        ----------
        size : positive int
            Number of indices to choose.
        n : positive int
            Upper bound of the interval in which the indices are chosen.

        Returns
        -------
        selection : :class:`~openturns.Indices`
            Sequence of size *size* of indices :math:`i` such that :math:`0\leq i<n`.

        """
        return _weightedexperiment.BootstrapExperiment_GenerateSelection(size, length)

    def __init__(self, *args):
        _weightedexperiment.BootstrapExperiment_swiginit(self, _weightedexperiment.new_BootstrapExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_BootstrapExperiment

# Register BootstrapExperiment in _weightedexperiment:
_weightedexperiment.BootstrapExperiment_swigregister(BootstrapExperiment)
class FixedExperiment(WeightedExperimentImplementation):
    r"""
    Fixed experiment.

    Parameters
    ----------
    aSample : 2-d sequence of float
        Sample that already exists.
    weights : sequence of float, optional
        Weights of each point of *aSample*.

    Notes
    -----
    FixedExperiment is a deterministic weighted design of experiments.
    It enables to take into account a random sample which has been obtained outside
    the study or at another step of the study.
    The :meth:`generate` method always gives the same sample, *aSample*, if it is
    recalled. When not specified, the weights associated to the points are all
    equal to :math:`1/cardI`. Then the sample *aSample* is considered as generated
    from the limit distribution
    :math:`\lim\limits_{cardI \to \infty} \sum_{i \in I} \omega_i \delta_{\vect{X}_i}=\mu`.
    The :meth:`setDistribution` method has no side effect, as the distribution is
    fixed by the initial sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> experiment = ot.FixedExperiment(sample)
    >>> print(experiment.generate())
    0 : [ 0 1 ]
    1 : [ 1 2 ]
    2 : [ 2 3 ]
    3 : [ 3 4 ]
    4 : [ 4 5 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.FixedExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.FixedExperiment___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.FixedExperiment_setDistribution(self, distribution)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.FixedExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.FixedExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.FixedExperiment_swiginit(self, _weightedexperiment.new_FixedExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_FixedExperiment

# Register FixedExperiment in _weightedexperiment:
_weightedexperiment.FixedExperiment_swigregister(FixedExperiment)
class GaussProductExperiment(WeightedExperimentImplementation):
    r"""
    Gauss product experiment.

    Available constructors:
        GaussProductExperiment(*marginalSizes*)

        GaussProductExperiment(*distribution*)

        GaussProductExperiment(*distribution, marginalSizes*)

    Parameters
    ----------
    marginalSizes : sequence of positive int
        Numbers of points :math:`s_j` for each direction. Then, the total number of
        points generated is :math:`\textrm{card}(I)=\prod_{j = 1}^{d_x} s_j`. 
        By default, the value of :math:`s_j` is equal to :math:`5`.
        The default marginal size is defined in the 
        `GaussProductExperiment-DefaultMarginalSize` key of the :class:`~openturns.ResourceMap`. 
    distribution :
        Distribution :math:`\mu` of dimension :math:`d_x` with an independent copula.

    Notes
    -----
    The Gauss product experiment is a tensor product experiment
    which uses Gauss points in each direction. 
    Using the notations of the :class:`~openturns.TensorProductExperiment`
    documentation, we have :math:`n_e = d_x` and :math:`d_j=1`
    for every index :math:`j = 1, ..., n_e`.

    For each marginal, the algorithm computes the family of orthogonal 
    polynomials depending on the marginal distribution using the
    :class:`~openturns.StandardDistributionPolynomialFactory` class. 
    The input distribution must have an independent copula.  

    See also
    --------
    WeightedExperiment, TensorProductExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> marginal_1 = ot.Exponential()
    >>> marginal_2 = ot.Triangular(-1.0, -0.5, 1.0)
    >>> distribution = ot.JointDistribution([marginal_1, marginal_2])
    >>> marginalSizes = [3, 2]
    >>> experiment = ot.GaussProductExperiment(distribution, marginalSizes)
    >>> nodes, weights = experiment.generateWithWeights()
    >>> print(nodes)
        [ X0        X1        ]
    0 : [  0.415775 -0.511215 ]
    1 : [  2.29428  -0.511215 ]
    2 : [  6.28995  -0.511215 ]
    3 : [  0.415775  0.357369 ]
    4 : [  2.29428   0.357369 ]
    5 : [  6.28995   0.357369 ]
    >>> print(weights)
    [0.429018,0.168036,0.00626806,0.282075,0.110482,0.00412119]

    In the following example [morokoff1995]_, we integrate a dimension 
    5 integrand with :math:`\mathcal{U}(0, 1)` marginal probability density functions.
    We use 7 nodes for each marginal, leading to a total of :math:`7^5 = 16807` nodes 
    for the tensor product Gauss quadrature. 

    >>> import openturns as ot
    >>> def g_function_py(x):
    ...     value = (1.0 + 1.0 / dimension) ** dimension
    ...     for i in range(dimension):
    ...         value *= x[i] ** (1.0 / dimension)
    ...     return [value]
    >>> 
    >>> dimension = 5
    >>> g_function = ot.PythonFunction(dimension, 1, g_function_py)
    >>> interval = ot.Interval([0.0] * dimension, [1.0] * dimension)
    >>> integral = 1.0
    >>> print('Exact integral = ', integral)
    Exact integral =  1.0
    >>> marginal_levels = [7] * dimension
    >>> distribution = ot.JointDistribution([ot.Uniform(0.0, 1.0)] * dimension)
    >>> experiment = ot.GaussProductExperiment(distribution, marginal_levels)
    >>> nodes, weights = experiment.generateWithWeights()
    >>> number_of_nodes = nodes.getSize()
    >>> print('Number of nodes = ', number_of_nodes)
    Number of nodes =  16807
    >>> function_values = g_function(nodes).asPoint()
    >>> approximate_integral = function_values.dot(weights)
    >>> print('Approximate integral = ', approximate_integral)
    Approximate integral =  1.0040...
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GaussProductExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.GaussProductExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.GaussProductExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.GaussProductExperiment_generateWithWeights(self)

    def isRandom(self):
        r"""
        Accessor to the randomness of quadrature.

        Parameters
        ----------
        isRandom : bool
            Is true if the design of experiments is random.
            Otherwise, the design of experiment is assumed to be deterministic.
        """
        return _weightedexperiment.GaussProductExperiment_isRandom(self)

    def setMarginalSizes(self, marginalSizes):
        r"""
        Set the marginal sizes.

        Parameters
        ----------
        marginalSizes : sequence of positive int
            Numbers of points :math:`s_j` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_setMarginalSizes(self, marginalSizes)

    def getMarginalSizes(self):
        r"""
        Get the marginal sizes.

        Returns
        -------
        marginalSizes : :class:`~openturns.Indices`
            Numbers of points :math:`s_j` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_getMarginalSizes(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.GaussProductExperiment_setDistribution(self, distribution)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
            Only available in dimension 1.
        """
        return _weightedexperiment.GaussProductExperiment_setSize(self, size)

    def __init__(self, *args):
        _weightedexperiment.GaussProductExperiment_swiginit(self, _weightedexperiment.new_GaussProductExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_GaussProductExperiment

# Register GaussProductExperiment in _weightedexperiment:
_weightedexperiment.GaussProductExperiment_swigregister(GaussProductExperiment)
class ImportanceSamplingExperiment(WeightedExperimentImplementation):
    r"""
    Importance Sampling experiment.

    Available constructors:
        ImportanceSamplingExperiment(*importanceDistribution*)

        ImportanceSamplingExperiment(*importanceDistribution, size*)

        ImportanceSamplingExperiment(*initialDistribution, importanceDistribution, size*)

    Parameters
    ----------
    initialDistribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` which is the initial distribution used to generate the
        set of input data.
    size : positive int
        Number of points that will be generated in the experiment.
    importanceDistribution : :class:`~openturns.Distribution`
        Distribution :math:`p` according to which the points of the 
        experiments will be generated with the Importance Sampling technique.

    Notes
    -----
    ImportanceSamplingExperiment is a random weighted design of experiments.
    We can use it to generate a sample :math:`(\inputReal_i)_{1 \leq i \leq \sampleSize}`
    based on independent observations from the distribution :math:`\inputMeasure`
    (see [hammersley1961]_ page 57, [lemieux2009]_ page 11). 
    Importance sampling is a variance reduction method i.e. it aims at 
    reducing the variance of the estimator of the weighted integral.
    The sample is generated from the importance distribution :math:`p` and each realization is weighted by   
    :math:`w_i = \frac{\inputProbabilityDensityFunction(\inputReal_i)}{p(\inputReal_i)}` where
    :math:`\inputProbabilityDensityFunction` is the probability density function of the 
    input random vector.

    There is no general method in the library to provide the importance distribution, 
    which must be specified by the user.
    In the specific case of rare event estimation, [morio2015]_ page 53 provides 
    different methods to compute the instrumental distribution, 
    including simple changes of measure and exponential twisting.
    The :class:`~openturns.PostAnalyticalImportanceSampling` class combines the :class:`~openturns.FORM` class
    and importance sampling to estimate a probability.

    The `ImportanceSamplingExperiment` class is nonadaptive, i.e. the parameters of the instrumental distribution are 
    set once for all.
    See :class:`~openturns.NAIS` for an adaptive importance sampling algorithm 
    and :class:`~openturns.experimental.CrossEntropyImportanceSampling` for another algorithm.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.JointDistribution([ot.Uniform(0, 1)] * 2)
    >>> importanceDistribution = ot.JointDistribution([ot.Uniform(0, 1)] * 2)
    >>> experiment = ot.ImportanceSamplingExperiment(distribution, importanceDistribution, 5)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [ 0.629877  0.882805  ]
    1 : [ 0.135276  0.0325028 ]
    2 : [ 0.347057  0.969423  ]
    3 : [ 0.92068   0.50304   ]
    4 : [ 0.0632061 0.292757  ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.ImportanceSamplingExperiment_getClassName(self)

    def getImportanceDistribution(self):
        r"""
        Accessor to the importance distribution.

        Returns
        -------
        importanceDistribution : :class:`~openturns.Distribution`
            Distribution :math:`p` according to which the points of the design of
            experiments will be generated with the Importance Sampling technique.
        """
        return _weightedexperiment.ImportanceSamplingExperiment_getImportanceDistribution(self)

    def __repr__(self):
        return _weightedexperiment.ImportanceSamplingExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.ImportanceSamplingExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.ImportanceSamplingExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.ImportanceSamplingExperiment_swiginit(self, _weightedexperiment.new_ImportanceSamplingExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_ImportanceSamplingExperiment

# Register ImportanceSamplingExperiment in _weightedexperiment:
_weightedexperiment.ImportanceSamplingExperiment_swigregister(ImportanceSamplingExperiment)
class LHSExperiment(WeightedExperimentImplementation):
    r"""
    LHS experiment.

    Available constructors:
        LHSExperiment(*size, alwaysShuffle, randomShift*)

        LHSExperiment(*distribution, size, alwaysShuffle, randomShift*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` used to generate the set of input data.
    size : positive int
        Number :math:`\mathrm{card}\,I` of points that will be generated in the experiment.
    alwaysShuffle : bool
        Flag to tell if the shuffle must be regenerated at each call to generate
        or not.
        Default is *False*: the shuffle is generated once and for all.

    randomShift : bool
        Flag to tell if the point selected in each cell of the shuffle is the center
        of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
        of the distribution to the cell.
        Default is *True*.

    Notes
    -----
    LHSExperiment is a random weighted design of experiments ([stein1987]_, [santner2003]_ page 127).
    The method generates a sample of points :math:`\inputReal_i` according to the
    distribution :math:`\inputMeasure` with the Latin Hypercube Sample (LHS) technique: some cells are determined,
    with the same probabilistic content according to the distribution, each line
    and each column contains exactly one cell, then points are selected among these
    selected cells. The weights associated to the points are all equal to
    :math:`\frac{1}{\sampleSize}` where :math:`\sampleSize` is the sample size.
    When recalled, the :meth:`generate` method generates a new
    sample: the point selection within the cells changes but not the cells
    selection. To change the cell selection, it is necessary to create a new 
    `LHSExperiment`.

    .. warning::

        When the distribution has a non-independent copula, the sample obtained by inverse
        isoprobabilistic transformation of an LHS experiment does not have the same properties
        as the original LHS experiment but can still be used to efficiently estimate
        threshold exceedance probabilities, especially when the copula is normal
        (as in this case the isoprobabilistic transformation is linear) and the limit-state is linear.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    Create an *LHSExperiment*:

    >>> import openturns as ot

    Generate the sample reusing the initial shuffle and using a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [  1.52938   -0.343515  ]
    1 : [ -0.0703427  2.36353   ]
    2 : [  0.576091  -1.79398   ]
    3 : [ -2.11636    0.619315  ]
    4 : [ -0.699601  -0.0570674 ]

    Generate the sample using a new shuffle and a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [ -1.72695   -0.591043  ]
    1 : [ -0.240653  -0.0406593 ]
    2 : [  0.828719   2.12547   ]
    3 : [  2.37061    0.508903  ]
    4 : [ -0.668296  -1.11573   ]

    Generate the sample reusing the initial shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]

    Generate the sample using a new shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.524401 -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [ -1.28155   0        ]
    3 : [ -0.524401  0.524401 ]
    4 : [  1.28155  -1.28155  ]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.LHSExperiment___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.LHSExperiment___str__(self, *args)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LHSExperiment_generateWithWeights(self)

    @staticmethod
    def ComputeShuffle(dimension, totalSize):
        r"""
        Generate a new cell randomization for external use.

        Parameters
        ----------
        dimension : positive int
            Number of input dimension.
        totalSize : positive int
            Number :math:`\mathrm{card}\,I` of points that need to be shuffled.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_ComputeShuffle(dimension, totalSize)

    def getShuffle(self):
        r"""
        Return the cell randomization.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_getShuffle(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.LHSExperiment_setDistribution(self, distribution)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`\sampleSize` of points constituting the design of experiments.
        """
        return _weightedexperiment.LHSExperiment_setSize(self, size)

    def getAlwaysShuffle(self):
        r"""
        Cell randomization flag accessor.

        Returns
        -------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_getAlwaysShuffle(self)

    def setAlwaysShuffle(self, alwaysShuffle):
        r"""
        Cell randomization flag accessor.

        Parameters
        ----------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_setAlwaysShuffle(self, alwaysShuffle)

    def getRandomShift(self):
        r"""
        Randomization flag accessor.

        Returns
        -------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_getRandomShift(self)

    def setRandomShift(self, randomShift):
        r"""
        Randomization flag accessor.

        Parameters
        ----------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_setRandomShift(self, randomShift)

    def __init__(self, *args):
        _weightedexperiment.LHSExperiment_swiginit(self, _weightedexperiment.new_LHSExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_LHSExperiment

# Register LHSExperiment in _weightedexperiment:
_weightedexperiment.LHSExperiment_swigregister(LHSExperiment)
class TemperatureProfileImplementation(openturns.common.PersistentObject):
    r"""
    Base class to define a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TemperatureProfileImplementation_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _weightedexperiment.TemperatureProfileImplementation___call__(self, i)

    def getT0(self):
        r"""
        Temperature origin accessor.

        Returns
        -------
        t0 : float
            The temperature origin
        """
        return _weightedexperiment.TemperatureProfileImplementation_getT0(self)

    def getIMax(self):
        r"""
        Maximum index value accessor.

        Returns
        -------
        iMax : int
            The maximum index value
        """
        return _weightedexperiment.TemperatureProfileImplementation_getIMax(self)

    def __repr__(self):
        return _weightedexperiment.TemperatureProfileImplementation___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.TemperatureProfileImplementation_swiginit(self, _weightedexperiment.new_TemperatureProfileImplementation(*args))
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementation

# Register TemperatureProfileImplementation in _weightedexperiment:
_weightedexperiment.TemperatureProfileImplementation_swigregister(TemperatureProfileImplementation)
class _TemperatureProfileImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject_swiginit(self, _weightedexperiment.new__TemperatureProfileImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete__TemperatureProfileImplementationTypedInterfaceObject

# Register _TemperatureProfileImplementationTypedInterfaceObject in _weightedexperiment:
_weightedexperiment._TemperatureProfileImplementationTypedInterfaceObject_swigregister(_TemperatureProfileImplementationTypedInterfaceObject)
class TemperatureProfile(_TemperatureProfileImplementationTypedInterfaceObject):
    r"""
    Base class to define a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TemperatureProfile_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _weightedexperiment.TemperatureProfile___call__(self, i)

    def getT0(self):
        r"""
        Temperature origin accessor.

        Returns
        -------
        t0 : float
            The temperature origin
        """
        return _weightedexperiment.TemperatureProfile_getT0(self)

    def getIMax(self):
        r"""
        Maximum index value accessor.

        Returns
        -------
        iMax : int
            The maximum index value
        """
        return _weightedexperiment.TemperatureProfile_getIMax(self)

    def __repr__(self):
        return _weightedexperiment.TemperatureProfile___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.TemperatureProfile_swiginit(self, _weightedexperiment.new_TemperatureProfile(*args))
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfile

# Register TemperatureProfile in _weightedexperiment:
_weightedexperiment.TemperatureProfile_swigregister(TemperatureProfile)
class GeometricProfile(TemperatureProfileImplementation):
    r"""
    Geometric temperature profile.

    Parameters
    ----------
    T0 : float
        Initial temperature
    c : float, optional
        The geometric ratio
        Should be in ]0,1[
    iMax : int, optional
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \begin{equation*}
            T(i) = T_0 * c^{i} \in [0,iMax]
        \end{equation*}

    Examples
    --------
    >>> import openturns as ot
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> c = 0.90
    >>> geometricProfile = ot.GeometricProfile(T0, c, iMax)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GeometricProfile_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------
        >>> import openturns as ot
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> c = 0.90
        >>> geometricProfile = ot.GeometricProfile(T0, c, iMax)
        >>> temperature = geometricProfile(5)
        >>> print(temperature)
        5.9049...
        """
        return _weightedexperiment.GeometricProfile___call__(self, i)

    def __repr__(self):
        return _weightedexperiment.GeometricProfile___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.GeometricProfile_swiginit(self, _weightedexperiment.new_GeometricProfile(*args))
    __swig_destroy__ = _weightedexperiment.delete_GeometricProfile

# Register GeometricProfile in _weightedexperiment:
_weightedexperiment.GeometricProfile_swigregister(GeometricProfile)
class LinearProfile(TemperatureProfileImplementation):
    r"""
    Linear temperature profile.

    Parameters
    ----------
    T0 : float
        Initial temperature
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \begin{equation*}
            T(i) = T_0*(1 - \frac{i}{iMax}), i \in [0,iMax]
        \end{equation*}

    Examples
    --------
    >>> import openturns as ot
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> linearProfile = ot.LinearProfile(T0, iMax)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LinearProfile_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------
        >>> import openturns as ot
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> linearProfile = ot.LinearProfile(T0, iMax)
        >>> temperature = linearProfile(10)
        >>> print(temperature)
        9.0
        """
        return _weightedexperiment.LinearProfile___call__(self, i)

    def __repr__(self):
        return _weightedexperiment.LinearProfile___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.LinearProfile_swiginit(self, _weightedexperiment.new_LinearProfile(*args))
    __swig_destroy__ = _weightedexperiment.delete_LinearProfile

# Register LinearProfile in _weightedexperiment:
_weightedexperiment.LinearProfile_swigregister(LinearProfile)
class SpaceFillingImplementation(openturns.common.PersistentObject):
    r"""
    Space filling computation base class.

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines
    how points fill the uniform space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingImplementation_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _weightedexperiment.SpaceFillingImplementation_evaluate(self, sample)

    def isMinimizationProblem(self):
        r"""
        Minimization flag accessor.

        Returns
        -------
        isMinimization : bool
            Whether the problem is a minimization.

        """
        return _weightedexperiment.SpaceFillingImplementation_isMinimizationProblem(self)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingImplementation___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingImplementation_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingImplementation_swiginit(self, _weightedexperiment.new_SpaceFillingImplementation(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementation

# Register SpaceFillingImplementation in _weightedexperiment:
_weightedexperiment.SpaceFillingImplementation_swigregister(SpaceFillingImplementation)
class _SpaceFillingImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment._SpaceFillingImplementationTypedInterfaceObject_swiginit(self, _weightedexperiment.new__SpaceFillingImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _weightedexperiment._SpaceFillingImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment._SpaceFillingImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment._SpaceFillingImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment._SpaceFillingImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment._SpaceFillingImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete__SpaceFillingImplementationTypedInterfaceObject

# Register _SpaceFillingImplementationTypedInterfaceObject in _weightedexperiment:
_weightedexperiment._SpaceFillingImplementationTypedInterfaceObject_swigregister(_SpaceFillingImplementationTypedInterfaceObject)
class SpaceFilling(_SpaceFillingImplementationTypedInterfaceObject):
    r"""
    Space filling computation base class.

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines
    how points fill the uniform space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFilling_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _weightedexperiment.SpaceFilling_evaluate(self, sample)

    def isMinimizationProblem(self):
        r"""
        Minimization flag accessor.

        Returns
        -------
        isMinimization : bool
            Whether the problem is a minimization.

        """
        return _weightedexperiment.SpaceFilling_isMinimizationProblem(self)

    def __repr__(self):
        return _weightedexperiment.SpaceFilling___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFilling_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFilling_swiginit(self, _weightedexperiment.new_SpaceFilling(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFilling

# Register SpaceFilling in _weightedexperiment:
_weightedexperiment.SpaceFilling_swigregister(SpaceFilling)
class SpaceFillingC2(SpaceFillingImplementation):
    r"""
    Space filling C2 (centered L2-discrepancy) computation.

    Notes
    -----
    Compute the centered L2 discrepancy:

    .. math::
        :nowrap:

        \begin{multline*}
        C^2(X_{d}^N) = \left(\frac{13}{12}\right)^{d} - \frac{2}{N} \sum_{i=1}^{N} \prod_{k=1}^{d} \left( 1 + \frac{1}{2} |x_k^{(i)} - 0.5| - \frac{1}{2} |x_k^{(i)} - 0.5|^2 \right)\\
                 + \frac{1}{N^2} \sum_{i,j=1}^{N} \prod_{k=1}^{d} \left( 1 + \frac{1}{2} |x_k^{(i)} - 0.5| + \frac{1}{2} |x_k^{(j)} - 0.5| - \frac{1}{2} |x_k^{(i)} - x_k^{(j)}| \right)
        \end{multline*}

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingC2_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the C2 criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        crit : float
            The C2 criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the C2 criterion
        >>> crit = ot.SpaceFillingC2().evaluate(design)
        """
        return _weightedexperiment.SpaceFillingC2_evaluate(self, sample)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingC2___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingC2_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingC2_swiginit(self, _weightedexperiment.new_SpaceFillingC2(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingC2

# Register SpaceFillingC2 in _weightedexperiment:
_weightedexperiment.SpaceFillingC2_swigregister(SpaceFillingC2)
class SpaceFillingMinDist(SpaceFillingImplementation):
    r"""
    Space filling minimal distance criterion.

    Notes
    -----
    Compute the criterion based on the minimal distance of sample points:

    .. math::
        :nowrap:

        \begin{equation*}
          \phi_{min}(X) = \min_{i \neq j} ||x^{(i)} - x^{(j)}||
        \end{equation*}

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingMinDist_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingMinDist___repr__(self)

    def evaluate(self, sample):
        r"""
        Compute the MinDist criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2-d array like
            The design

        Returns
        -------
        crit : float
            The MinDist criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the MinDist criterion
        >>> crit = ot.SpaceFillingMinDist().evaluate(design)
        """
        return _weightedexperiment.SpaceFillingMinDist_evaluate(self, sample)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingMinDist_swiginit(self, _weightedexperiment.new_SpaceFillingMinDist(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingMinDist

# Register SpaceFillingMinDist in _weightedexperiment:
_weightedexperiment.SpaceFillingMinDist_swigregister(SpaceFillingMinDist)
class SpaceFillingPhiP(SpaceFillingImplementation):
    r"""
    Space filling PhiP.

    Parameters
    ----------
    p : int (default=50)
        Parameter for parametrizing the criterion

    Notes
    -----
    Computes the criterion:

    .. math::
        :nowrap:

        \begin{equation*}
          \phi_p(X) = \sum_{i=1}^{j} \sum_{j=1}^{n} \left( |x^{(i)} - x^{(j)}|^{-p} \right)^{\frac{1}{p}}
        \end{equation*}

    This criterion is known to converge to mindist (minimal distance between two distinct elements of the design) criterion when p tends to infinity.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingPhiP_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the PhiP criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        crit : float
            The phiP criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the PhiP criterion
        >>> crit = ot.SpaceFillingPhiP(50).evaluate(design)
        """
        return _weightedexperiment.SpaceFillingPhiP_evaluate(self, sample)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingPhiP___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingPhiP_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingPhiP_swiginit(self, _weightedexperiment.new_SpaceFillingPhiP(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingPhiP

# Register SpaceFillingPhiP in _weightedexperiment:
_weightedexperiment.SpaceFillingPhiP_swigregister(SpaceFillingPhiP)
class LHSResult(openturns.common.PersistentObject):
    r"""
    Summarize the results of an LHS optimization.

    Parameters
    ----------
    spaceFilling : :class:`~openturns.SpaceFilling`
        The space filling criteria used by optimization algorithm
    nRestart : int
        The number of restarts performed by optimization algorithm

    Notes
    -----
    This class is not intendeted to be built by hand, but returned by optimization algorithms.

    Examples
    --------
    >>> import openturns as ot
    >>> lhs = ot.LHSExperiment(ot.JointDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> profile = ot.GeometricProfile()
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # Optim algo
    >>> algo = ot.SimulatedAnnealingLHS(lhs, spaceFilling, profile)
    >>> # first, generate a design
    >>> design = algo.generate()
    >>> # then, get the result
    >>> result = algo.getResult()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSResult_getClassName(self)

    def getNumberOfRestarts(self):
        r"""
        Restart number accessor.

        Returns
        -------
        restart : int (optional)
            The number of restart.
        """
        return _weightedexperiment.LHSResult_getNumberOfRestarts(self)

    def getOptimalDesign(self, *args):
        r"""
        Accessor to the optimal design.

        Returns
        -------
        design : :class:`~openturns.Sample`
            The design that optimizes the criterion.

        """
        return _weightedexperiment.LHSResult_getOptimalDesign(self, *args)

    def getOptimalValue(self, *args):
        r"""
        Optimal value accessor.

        Returns
        -------
        value : float (optional)
            The optimal value.
        """
        return _weightedexperiment.LHSResult_getOptimalValue(self, *args)

    def getAlgoHistory(self, *args):
        r"""
        Accessor to the internal values computed during optimization algorithm.

        Returns
        -------
        history : :class:`~openturns.Point`
            Some internal values computed during optimization algorithm.
            SimulatedAnnealingLHS stores criterion value, temperature
            and probability at each iteration.

        """
        return _weightedexperiment.LHSResult_getAlgoHistory(self, *args)

    def getC2(self, *args):
        r"""
        Accessor to the C2 criterion evaluated on the optimal design.

        Returns
        -------
        c2 : float
            The C2 criterion.

        """
        return _weightedexperiment.LHSResult_getC2(self, *args)

    def getPhiP(self, *args):
        r"""
        Accessor the PhiP criterion evaluated on the optimal design.

        Returns
        -------
        phiP : float
            The PhiP criterion.

        """
        return _weightedexperiment.LHSResult_getPhiP(self, *args)

    def getMinDist(self, *args):
        r"""
        Minimum distance accessor.

        Parameters
        ----------
        restart : int (optional)
            The restart index.

        Returns
        -------
        minDist : float
            The minimum distance of sample points.
        """
        return _weightedexperiment.LHSResult_getMinDist(self, *args)

    def drawHistoryCriterion(self, *args):
        r"""
        Draw criterion history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryCriterion(self, *args)

    def drawHistoryProbability(self, *args):
        r"""
        Draw probability history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryProbability(self, *args)

    def drawHistoryTemperature(self, *args):
        r"""
        Draw temperature history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryTemperature(self, *args)

    def __repr__(self):
        return _weightedexperiment.LHSResult___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.LHSResult_swiginit(self, _weightedexperiment.new_LHSResult(*args))
    __swig_destroy__ = _weightedexperiment.delete_LHSResult

# Register LHSResult in _weightedexperiment:
_weightedexperiment.LHSResult_swigregister(LHSResult)
class OptimalLHSExperiment(WeightedExperimentImplementation):
    r"""
    OptimalLHS base class.

    See also
    --------
    MonteCarloLHS, SimulatedAnnealingLHS

    Notes
    -----
    Perform the generation of optimal LHS designs.

    See a complementary bibiliographic reference: [mckay1979]_
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.OptimalLHSExperiment_getClassName(self)

    def getLHS(self):
        r"""
        Return the LHS design.

        Returns
        -------
        value : :class:`~openturns.LHSExperiment`
            Result the factory that builds initial design to be optimized
        """
        return _weightedexperiment.OptimalLHSExperiment_getLHS(self)

    def getSpaceFilling(self):
        r"""
        Return the space-filling criterion to be optimized.

        Returns
        -------
        value : :class:`~openturns.SpaceFilling`
            Criterion function to be optimized
        """
        return _weightedexperiment.OptimalLHSExperiment_getSpaceFilling(self)

    def getResult(self):
        r"""
        Result accessor.

        Returns
        -------
        value : :class:`~openturns.LHSResult`
            Result of generation that contains the optimal design, some criteria and history
        """
        return _weightedexperiment.OptimalLHSExperiment_getResult(self)

    def __repr__(self):
        return _weightedexperiment.OptimalLHSExperiment___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.OptimalLHSExperiment_swiginit(self, _weightedexperiment.new_OptimalLHSExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_OptimalLHSExperiment

# Register OptimalLHSExperiment in _weightedexperiment:
_weightedexperiment.OptimalLHSExperiment_swigregister(OptimalLHSExperiment)
class MonteCarloLHS(OptimalLHSExperiment):
    r"""
    Monte Carlo LHS optimization.

    Performs the optimization of an LHS using Monte Carlo simulations.

    Parameters
    ----------
    lhsDesign : :class:`~openturns.LHSExperiment`
         Factory that generate designs
    N : int
        Number of simulations
    spaceFilling : :class:`~openturns.SpaceFilling`, optional
        Criterion to be optimized, default is :class:`~openturns.SpaceFillingMinDist`

    Notes
    -----
    MonteCarloLHS generates :math:`N` LHS designs and returns the optimal one with
    respect to a space-filling criterion.
    Unlike :class:`~openturns.SimulatedAnnealingLHS` it does not apply cell swaps
    directly so the design may not change that much if the shuffle property of the
    :class:`~openturns.LHSExperiment` is disabled.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> distribution = ot.JointDistribution([ot.Uniform(0.0, 1.0)]*dimension)
    >>> lhs = ot.LHSExperiment(distribution, size)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> # Defining space fillings
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # RandomBruteForce MonteCarlo with N designs (LHS with C2 optimization)
    >>> N = 10000
    >>> optimalLHSAlgorithm = ot.MonteCarloLHS(lhs, N, spaceFilling)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloLHS_getClassName(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloLHS_generateWithWeights(self)

    def __repr__(self):
        return _weightedexperiment.MonteCarloLHS___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.MonteCarloLHS_swiginit(self, _weightedexperiment.new_MonteCarloLHS(*args))
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloLHS

# Register MonteCarloLHS in _weightedexperiment:
_weightedexperiment.MonteCarloLHS_swigregister(MonteCarloLHS)
class SimulatedAnnealingLHS(OptimalLHSExperiment):
    r"""
    LHS optimization using simulated annealing.

    Performs the optimization of an LHS using simulated annealing algorithm.

    Available constructors:

        SimulatedAnnealingLHS(*lhsDesign*)

        SimulatedAnnealingLHS(*lhsDesign, spaceFilling*)

        SimulatedAnnealingLHS(*lhsDesign, spaceFilling, profile*)

        SimulatedAnnealingLHS(*initialDesign, distribution*)

        SimulatedAnnealingLHS(*initialDesign, distribution, spaceFilling*)

        SimulatedAnnealingLHS(*initialDesign, distribution, spaceFilling, profile*)

    Parameters
    ----------
    lhsDesign : :class:`~openturns.LHSExperiment`
        Factory that generate designs
    initialDesign : 2d-array sequence
        Initial design to be optimized
    distribution : :class:`~openturns.Distribution`
        Distribution of designs
    spaceFilling : :class:`~openturns.SpaceFilling`
        Criterion to be optimized
        Default is :class:`~openturns.SpaceFillingPhiP`
    profile : :class:`~openturns.TemperatureProfile`
        Temperature profile used by the simulated annealing algorithm
        Default is :class:`~GeometricProfile`

    Notes
    -----

    With the first constructor, the initial design is generated thanks to lhsDesign.
    With the second usage (initialDesign), it must be already generated.
    Starting from this design, a new design is obtained by swapping one random
    coordinate of two randomly chosen elements; by construction, this design is also an LHS design.
    If the new design is better than the previous one, it is kept.  
    If it is worse, it may anyway be kept with some probability, which depends on
    how these designs compare, but also on a temperature profile T which decreases over time.
    This means that jumping away from local extrema becomes less probable over time.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> distribution = ot.JointDistribution([ot.Uniform(0.0, 1.0)]*dimension)
    >>> lhs = ot.LHSExperiment(distribution, size)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> # Defining space fillings
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # Geometric profile
    >>> geomProfile = ot.GeometricProfile(10.0, 0.95, 2000)
    >>> # Simulated Annealing LHS with geometric temperature profile, C2 optimization
    >>> optimalLHSAlgorithm = ot.SimulatedAnnealingLHS(lhs, spaceFilling, geomProfile)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SimulatedAnnealingLHS_getClassName(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.SimulatedAnnealingLHS_generateWithWeights(self)

    def generateWithRestart(self, nRestart):
        r"""
        Generate sample with restart.

        Randomly generate several samples from an initial state
        and select the one that has the best score.

        Parameters
        ----------
        nRestart : int
            Number of restarts

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The best scored sample across restarts

        """
        return _weightedexperiment.SimulatedAnnealingLHS_generateWithRestart(self, nRestart)

    def __repr__(self):
        return _weightedexperiment.SimulatedAnnealingLHS___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.SimulatedAnnealingLHS_swiginit(self, _weightedexperiment.new_SimulatedAnnealingLHS(*args))
    __swig_destroy__ = _weightedexperiment.delete_SimulatedAnnealingLHS

# Register SimulatedAnnealingLHS in _weightedexperiment:
_weightedexperiment.SimulatedAnnealingLHS_swigregister(SimulatedAnnealingLHS)
class LowDiscrepancyExperiment(WeightedExperimentImplementation):
    r"""
    LowDiscrepancy experiment.

    Available constructors:
        LowDiscrepancyExperiment(*size, restart*)

        LowDiscrepancyExperiment(*sequence, size, restart*)

        LowDiscrepancyExperiment(*sequence, distribution, size, restart*)

    Parameters
    ----------
    size : positive int
        Number :math:`N` of points of the sequence.
    sequence : :class:`~openturns.LowDiscrepancySequence`
        Sequence of points :math:`(u_1, \cdots, u_N)` with low discrepancy.
        If not specified, the sequence is a :class:`~openturns.SobolSequence`.
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` of dimension :math:`n`.
        The low discrepancy sequence :math:`(u_1, \cdots, u_N)` is uniformly
        distributed over :math:`[0,1]^n`. We use an iso-probabilistic transformation
        from the independent copula of dimension :math:`n` to the given distribution.
        The weights are all equal to :math:`1/N`.
    restart : bool
        Flag to tell if the low discrepancy sequence must be restarted from
        its initial state at each change of distribution or not.
        Default is *True*: the sequence is restarted at each change of
        distribution.

    Notes
    -----
    The :meth:`generate` method generates points :math:`(\Xi_i)_{i \in I}`
    according to the distribution :math:`\mu`. When the :meth:`generate`
    method is called again, the generated sample changes. In case of dependent
    marginals, the approach based on [cambou2017]_ is used.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.JointDistribution([ot.Uniform(0.0, 1.0)] * 2)

    Generate the sample with a reinitialization of the sequence at each change
    of distribution:

    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, True)
    >>> print(experiment.generate())
        [ y0    y1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(experiment.generate())
        [ y0     y1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> experiment.setDistribution(distribution)
    >>> print(experiment.generate())
        [ y0    y1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]

    Generate the sample keeping the previous state of the sequence at each change
    of distribution:

    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, False)
    >>> print(experiment.generate())
        [ y0    y1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(experiment.generate())
        [ y0     y1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> experiment.setDistribution(distribution)
    >>> print(experiment.generate())
        [ y0     y1     ]
    0 : [ 0.4375 0.5625 ]
    1 : [ 0.3125 0.1875 ]
    2 : [ 0.8125 0.6875 ]
    3 : [ 0.5625 0.4375 ]
    4 : [ 0.0625 0.9375 ]

    Generate a sample according to a distribution with dependent marginals:

    >>> distribution = ot.Normal([0.0]*2, ot.CovarianceMatrix(2, [4.0, 1.0, 1.0, 9.0]))
    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, False)
    >>> print(experiment.generate())
        [ y0        y1        ]
    0 : [  0         0        ]
    1 : [  1.34898  -1.65792  ]
    2 : [ -1.34898   1.65792  ]
    3 : [ -0.637279 -1.10187  ]
    4 : [  2.3007    3.97795  ]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.LowDiscrepancyExperiment___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.LowDiscrepancyExperiment___str__(self, *args)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the input random vector.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_setDistribution(self, distribution)

    def getSequence(self):
        r"""
        Return the sequence.

        Returns
        -------
        sequence : :class:`~openturns.LowDiscrepancySequence`
            Sequence of points :math:`(u_1, \cdots, u_N)` with low discrepancy.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getSequence(self)

    def getRestart(self):
        r"""
        Return the value of the *restart* flag.

        Returns
        -------
        restart : bool
            The value of the *restart* flag.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getRestart(self)

    def setRestart(self, restart):
        r"""
        Set the value of the *restart* flag.

        Parameters
        ----------
        restart : bool
            The value of the *restart* flag. If equals to *True*, the low
            discrepancy sequence is restarted at each change of distribution,
            else it is changed only if the new distribution has a dimension
            different from the current one.

        """
        return _weightedexperiment.LowDiscrepancyExperiment_setRestart(self, restart)

    def getRandomize(self):
        r"""
        Return the value of the *randomize* flag.

        Returns
        -------
        randomize : bool
            The value of the *randomize* flag.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getRandomize(self)

    def setRandomize(self, randomize):
        r"""
        Set the value of the *randomize* flag.

        Parameters
        ----------
        randomize : bool
            Use a cyclic scrambling of the low discrepancy sequence, it means, the whole
            low discrepancy sequence is translated by a random vector modulo 1.
            See [lecuyer2005]_ for the interest of such a scrambling.
            Default is False.

        """
        return _weightedexperiment.LowDiscrepancyExperiment_setRandomize(self, randomize)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LowDiscrepancyExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.LowDiscrepancyExperiment_swiginit(self, _weightedexperiment.new_LowDiscrepancyExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_LowDiscrepancyExperiment

# Register LowDiscrepancyExperiment in _weightedexperiment:
_weightedexperiment.LowDiscrepancyExperiment_swigregister(LowDiscrepancyExperiment)
class MonteCarloExperiment(WeightedExperimentImplementation):
    r"""
    MonteCarlo experiment.

    Available constructors:
        MonteCarloExperiment(*distribution, size*)

        MonteCarloExperiment(*size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`\sampleSize` of points that will be generated in the experiment.

    Notes
    -----
    MonteCarloExperiment is a random weighted design of experiments (see [hammersley1961]_ page 51, [lemieux2009]_ page 3).
    The :meth:`generate` method computes the nodes :math:`(\inputReal_i)_{i = 1, ..., \sampleSize}`
    by generating independent observations from the distribution :math:`\mu`. The weights associated to the
    points are all equal to :math:`w_i = \frac{1}{\sampleSize}` where :math:`\sampleSize` is the sample size. 
    When the :meth:`generate` method is
    called a second time, the generated sample changes.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.608202 -1.26617  ]
    1 : [ -0.438266  1.20548  ]
    2 : [ -2.18139   0.350042 ]
    3 : [ -0.355007  1.43725  ]
    4 : [  0.810668  0.793156 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.MonteCarloExperiment___repr__(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.MonteCarloExperiment_swiginit(self, _weightedexperiment.new_MonteCarloExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloExperiment

# Register MonteCarloExperiment in _weightedexperiment:
_weightedexperiment.MonteCarloExperiment_swigregister(MonteCarloExperiment)
class _SplitterImplementationdInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment._SplitterImplementationdInterfaceObject_swiginit(self, _weightedexperiment.new__SplitterImplementationdInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _weightedexperiment._SplitterImplementationdInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment._SplitterImplementationdInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment._SplitterImplementationdInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment._SplitterImplementationdInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment._SplitterImplementationdInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete__SplitterImplementationdInterfaceObject

# Register _SplitterImplementationdInterfaceObject in _weightedexperiment:
_weightedexperiment._SplitterImplementationdInterfaceObject_swigregister(_SplitterImplementationdInterfaceObject)
class SplitterImplementation(openturns.common.PersistentObject):
    r"""Base class to split samples in train/test sets."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SplitterImplementation_getClassName(self)

    def __init__(self, *args):
        _weightedexperiment.SplitterImplementation_swiginit(self, _weightedexperiment.new_SplitterImplementation(*args))

    def getN(self):
        r"""
        Set size accessor.

        Returns
        -------
        N : int
            Size of the set of indices in which the indices are chosen
        """
        return _weightedexperiment.SplitterImplementation_getN(self)

    def getSize(self):
        r"""
        Number of sets generated.

        Returns
        -------
        length : int
            Number of sets of indices generated.
        """
        return _weightedexperiment.SplitterImplementation_getSize(self)

    def __repr__(self):
        return _weightedexperiment.SplitterImplementation___repr__(self)

    def __iter__(self):
        return _weightedexperiment.SplitterImplementation___iter__(self)

    def __next__(self):
        return _weightedexperiment.SplitterImplementation___next__(self)
    __swig_destroy__ = _weightedexperiment.delete_SplitterImplementation

# Register SplitterImplementation in _weightedexperiment:
_weightedexperiment.SplitterImplementation_swigregister(SplitterImplementation)
class KFoldSplitter(SplitterImplementation):
    r"""
    K-fold splitter.

    Generates train/test indices to split samples in train/test sets.
    The sample is split into k folds.
    Each fold is then used once as test while the k - 1 other folds form the training set.

    Parameters
    ----------
    N : int
        Size of the set of indices in which the indices are chosen
    k : int
        Number of folds

    Examples
    --------
    >>> import openturns as ot
    >>> sample = ot.Normal().getSample(10)
    >>> k = 5
    >>> splitter = ot.KFoldSplitter(sample.getSize(), k)
    >>> for indicesTrain, indicesTest in splitter:
    ...     sampleTrain, sampleTest = sample[indicesTrain], sample[indicesTest]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.KFoldSplitter_getClassName(self)

    def getSize(self):
        r"""
        Number of sets generated.

        Returns
        -------
        length : int
            Number of sets of indices generated.
        """
        return _weightedexperiment.KFoldSplitter_getSize(self)

    def setRandomize(self, randomize):
        r"""
        Set the value of the *randomize* flag.

        Note that the default value is set via the ResourceMap entry `KFoldSplitter-Randomize`.

        Parameters
        ----------
        randomize : bool
            Scramble the folds.
        """
        return _weightedexperiment.KFoldSplitter_setRandomize(self, randomize)

    def __repr__(self):
        return _weightedexperiment.KFoldSplitter___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.KFoldSplitter_swiginit(self, _weightedexperiment.new_KFoldSplitter(*args))
    __swig_destroy__ = _weightedexperiment.delete_KFoldSplitter

# Register KFoldSplitter in _weightedexperiment:
_weightedexperiment.KFoldSplitter_swigregister(KFoldSplitter)
class LeaveOneOutSplitter(SplitterImplementation):
    r"""
    Leave-one-out splitter.

    Generates train/test indices to split samples in train/test sets.
    Each sample is used once as a test set while the remaining samples form the training set.

    Parameters
    ----------
    N : int
        Size of the set of indices in which the indices are chosen

    Examples
    --------
    >>> import openturns as ot
    >>> X = ot.Normal().getSample(10)
    >>> splitter = ot.LeaveOneOutSplitter(X.getSize())
    >>> for indicesTrain, indicesTest in splitter:
    ...     XTrain, XTest = X[indicesTrain], X[indicesTest]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LeaveOneOutSplitter_getClassName(self)

    def getSize(self):
        r"""
        Number of sets generated.

        Returns
        -------
        length : int
            Number of sets of indices generated.
        """
        return _weightedexperiment.LeaveOneOutSplitter_getSize(self)

    def __repr__(self):
        return _weightedexperiment.LeaveOneOutSplitter___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.LeaveOneOutSplitter_swiginit(self, _weightedexperiment.new_LeaveOneOutSplitter(*args))
    __swig_destroy__ = _weightedexperiment.delete_LeaveOneOutSplitter

# Register LeaveOneOutSplitter in _weightedexperiment:
_weightedexperiment.LeaveOneOutSplitter_swigregister(LeaveOneOutSplitter)
class TensorProductExperiment(WeightedExperimentImplementation):
    r"""
    Tensor product experiment.

    Parameters
    ----------
    experiments : list of :class:`~openturns.WeightedExperiment`
        List of :math:`n` marginal experiments of the tensor product experiment. 
        Each marginal experiment can have arbitrary dimension.

    Notes
    -----
    The tensor product design of experiments (DOE) is based on a collection 
    of marginal multidimensional elementary designs of experiments. 
    It is anisotropic in the sense that each marginal DOE does not necessarily 
    have the same size. Using more points in one component may be useful if we 
    want to get more accurate results in that particular direction. 

    Furthermore, each marginal DOE does not necessarily have a dimension 
    equal to 1. In this sense, this is a generalization of a classical 
    tensor product DOE. 

    Let :math:`\mathcal{X} \subset \mathbb{R}^{d_x}` be the integration domain 
    and let :math:`g : \mathcal{X} \rightarrow \mathbb{R}^{d_y}` be an integrable 
    function. 
    Let :math:`f : \mathcal{X} \rightarrow \mathbb{R}` be a probability density 
    function. The tensor product experiment produces an approximation of the 
    integral :

    .. math::

        \int_{\mathcal{X}} g(\vect{x}) f(\vect{x}) d\vect{x} 
        \approx \sum_{i = 1}^{s_t} w_i g\left(\vect{x}_i\right)

    where :math:`s_t \in \mathbb{N}` is the size of the tensor product 
    design of experiments, :math:`w_1, ..., w_{s_t} \in \mathbb{R}` are the 
    weights and :math:`\vect{x}_1, ..., \vect{x}_{s_t} \in \mathbb{R}^{d_x}` 
    are the nodes. 

    Let :math:`n_e \in \mathbb{N}` be the number of marginal DOEs. 
    For each marginal DOE index :math:`j = 1, ..., n_e`, 
    let :math:`s_j \in \mathbb{N}` be its size, representing the number of 
    nodes in the marginal DOE, and
    let :math:`d_j \in \mathbb{N}` be 
    the dimension of the :math:`j`-th marginal DOE. 
    Let :math:`\left\{ Q_{s_j}^{(d_j)} \right\}_{j = 1, ..., n_e}` be the 
    collection of marginal DOEs.
    The dimension of the tensor product experiment is equal to the sum of the 
    dimensions of the marginal DOEs:

    .. math::

        d_x = \sum_{j = 1}^{n_e} d_j.

    The size of the tensor product experiment is equal to the product of the 
    marginal DOE sizes:

    .. math::

        s_t = \prod_{j = 1}^{n_e} s_j.

    Let :math:`\vect{k} = \left(k_1, ..., k_{n_e}\right) \in (\mathbb{N}^\star)^{n_e}`  
    be a multi-index where :math:`\mathbb{N}^\star = \{1, 2, ..., \}` is 
    the set of positive integers. For any marginal DOE :math:`j = 1,..., n_e`, 
    let :math:`\left\{w_{s_j, k_j} \right\}_{k_j = 1, ..., s_j}` be its 
    weights and let :math:`\left\{ \vect{x}_{s_j, k_j} \in \mathbb{R}^{d_j} \right\}_{k_j = 1, ..., s_j}` 
    be its nodes. 

    The tensor product quadrature is ([gerstner1998]_ page 214):

    .. math::

        Q^{(d_x)}_{s_t} = Q_{s_1}^{(d_1)} \otimes \cdots \otimes Q_{s_{n_e}}^{(d_{n_e})}

    where:

    .. math::

        Q_{s_1}^{(d_1)} \otimes \cdots \otimes Q_{s_{n_e}}^{(d_{n_e})} (g) 
        = \sum_{k_1 = 1}^{s_1} \cdots \sum_{k_{n_e} = 1}^{s_{n_e}} 
        w_{s_1, k_1} \cdots w_{s_{n_e}, k_{n_e}}  
        g\left(\vect{x}_{s_1, k_1}, \ldots, \vect{x}_{s_{n_e}, k_{n_e}}\right).

    For any multi-index :math:`\vect{k} = (k_1, ..., k_{n_e}) \in (\mathbb{N}^\star)^{n_e}`, 
    we write 

    .. math::

        \vect{k} \leq \left(s_1, ..., s_{n_e}\right)

    if and only if :math:`k_j \leq s_j` for :math:`j = 1, ..., n_e`. 
    This means that each component of the multi-index is less than or equal to its 
    corresponding marginal size.
    The set of multi-indices such that :math:`\vect{k} \leq \left(s_1, ..., s_{n_e}\right)` 
    is produced using all possible combinations of the indices with 
    the :class:`~openturns.Tuples` class.

    The tensor product experiment is:

    .. math::

        Q_{s_1}^{(d_1)} \otimes \cdots \otimes Q_{s_{n_e}}^{(d_{n_e})} (g) 
        = \sum_{\vect{k} \leq \left(s_1, ..., s_{n_e}\right)}  
        w_{\vect{k}} g\left(\vect{x}_{\vect{k}}\right),

    where each weight is equal to the product of the marginal elementary weights:

    .. math::

        w_{\vect{k}} = \prod_{j = 1}^{n_e} w_{s_j, k_j} \in \mathbb{R}

    and each node is equal to the agregation of the marginal elementary nodes:

    .. math::

        \vect{x}_{\vect{k}}
        = \left(\vect{x}_{s_1, k_1}, \ldots, \vect{x}_{s_{n_e}, k_{n_e}}\right) \in \mathbb{R}^{d_x}.


    See also
    --------
    WeightedExperiment, GaussProductExperiment

    Examples
    --------
    In the following example, we tensorize two Gauss-Legendre 
    quadratures, using 3 nodes in the first dimension and 5 nodes in the second.

    >>> import openturns as ot
    >>> experiment1 = ot.GaussProductExperiment(ot.Uniform(0.0, 1.0), [3])
    >>> experiment2 = ot.GaussProductExperiment(ot.Uniform(0.0, 1.0), [5])
    >>> collection = [experiment1, experiment2]
    >>> multivariate_experiment = ot.TensorProductExperiment(collection)
    >>> nodes, weights = multivariate_experiment.generateWithWeights()

    Marginal DOEs do not necessarily have dimension 1. 
    In the following example, we tensorize two DOEs, where the 
    first one has dimension 2, and the second one has dimension 3.

    >>> # Experiment 1 : Uniform * 2 with 3 and 2 nodes.
    >>> marginal_sizes_1 = [3, 2]
    >>> dimension_1 = len(marginal_sizes_1)
    >>> distribution_1 = ot.JointDistribution([ot.Uniform()] * dimension_1)
    >>> experiment_1 = ot.GaussProductExperiment(distribution_1, marginal_sizes_1)
    >>> # Experiment 2 : Normal * 3 with 2, 2 and 1 nodes.
    >>> marginal_sizes_2 = [2, 2, 1]
    >>> dimension_2 = len(marginal_sizes_2)
    >>> distribution_2 = ot.JointDistribution([ot.Normal()] * dimension_2)
    >>> experiment_2 = ot.GaussProductExperiment(distribution_2, marginal_sizes_2)
    >>> # Tensor product
    >>> collection = [experiment_1, experiment_2]
    >>> multivariate_experiment = ot.TensorProductExperiment(collection)
    >>> nodes, weights = multivariate_experiment.generateWithWeights()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TensorProductExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.TensorProductExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.TensorProductExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points of the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`\sampleSize`
            Weights :math:`(w_i)_{i = 1, ..., \sampleSize}` associated with the points. By default,
            all the weights are equal to :math:`\frac{1}{\sampleSize}`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.TensorProductExperiment_generateWithWeights(self)

    def setWeightedExperimentCollection(self, coll):
        r"""
        Set the marginals of the experiment.

        Parameters
        ----------
        coll : list of :class:`~openturns.WeightedExperiment`
            List of the marginals of the experiment.
        """
        return _weightedexperiment.TensorProductExperiment_setWeightedExperimentCollection(self, coll)

    def getWeightedExperimentCollection(self):
        r"""
        Get the marginals of the experiment.

        Returns
        -------
        coll : list of :class:`~openturns.WeightedExperiment`
            List of the marginals of the experiment.
        """
        return _weightedexperiment.TensorProductExperiment_getWeightedExperimentCollection(self)

    def __init__(self, *args):
        _weightedexperiment.TensorProductExperiment_swiginit(self, _weightedexperiment.new_TensorProductExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_TensorProductExperiment

# Register TensorProductExperiment in _weightedexperiment:
_weightedexperiment.TensorProductExperiment_swigregister(TensorProductExperiment)

