%feature("docstring") OT::SimulationSensitivityAnalysis
"Class to perform a sensitivity analysis based on a reliability event.

Available constructor:
    SimulationSensitivityAnalysis(*event, inputSample, outputSample*)

    SimulationSensitivityAnalysis(*event*)

    SimulationSensitivityAnalysis(*simulationRes*)

Parameters
----------
event : :class:`~openturns.RandomVector`
    An event which it composite (test is with the method
    :meth:`isComposite <openturns.RandomVector.isComposite>`).
inputSample, outputSample : 2-d sequence of float
    Input sample and output sample of a model evaluated apart.
simulationRes : :class:`~openturns.ProbabilitySimulationResult`
    A simulation result.

Notes
-----
The simulation sensitivity analysis is based on:

- in the first usage, the *inputSample* and *outputSample* given:
- in the second usage, the samples which have been stored by the function
  defining the event. Care if the sample is not a statistical sample: post
  treatment proposed by the object might not be right.
- in the third usage, the samples generated by the
  :class:`~openturns.EventSimulation` that produced *simulationRes*."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::computeImportanceFactors
"Compute the importance factors.

Returns
-------
impFactors : :class:`~openturns.PointWithDescription`
    The importance factors.

Notes
-----
The importance factors, given in :eq:`importance_factor`, are evaluated from the
coordinates of the mean point :eq:`mean_point` of the event domain, mapped into
the standard space as follows:

.. math::
    :label: mean_point

    \\vect{X}^*_{event} = \\frac{1}{n} \\sum_{i=1}^n \\vect{X}_i 1_{event} (\\vect{X}_i)

.. math::
    :label: importance_factor

    \\alpha_i = \\frac{ (U_i^*)^2 }{ \\left\\| \\vect{U}^* \\right\\| }

where

.. math::

    \\vect{U}^* = T(\\vect{X}^*_{event})

Be careful: this notion is only valid for :class:`~openturns.MonteCarloExperiment` or
:class:`~openturns.LHSExperiment` sampling as the mean is evaluated from the equation
:eq:`importance_factor` (only uniform weights over the realizations
:math:`\\vect{X}_i`."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::computeMeanPointInEventDomain
"Accessor to the mean point.

Returns
-------
mean : :class:`~openturns.Point`
    The mean point in the failure domain.

Notes
-----
This method computes the mean point in the physical space of all the simulations
generated by the simulation that failed into the event domain.

Be careful: this notion is only valid for Monte Carlo or LHS sampling as the
mean is evaluated from the equation :eq:`mean_point` (only uniform weights over
the realizations :math:`\\vect{X}_i`."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::drawImportanceFactors
"Draw the importance factors.

Returns
-------
graph : :class:`~openturns.Graph`
    Graph containing the pie corresponding to the importance factors of the probabilistic variables."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::drawImportanceFactorsRange
"Draw the importance factors evolution.

Parameters
----------
probabilityScale : boolean
    Set True if the limits are the probability levels; set False if the limits are
    the thresholds defining the event.
lower, upper : floats
    Define the boundaries of the probability levels :math:`p_{min}` and
    :math:`p_{max}` or those of the thresholds :math:`s_{min}` and :math:`s_{max}`. 

Returns
-------
graph : :class:`~openturns.Graph`
    A graph that draws the evolution of the importance factors of each direction
    with respect to :math:`p \\in [p_{min}, p_{max}]` or
    :math:`s \\in [s_{min}, s_{max}]`. The importance factors are evaluated from
    the definition :eq:`importance_factor` for each threshold *s* or probability
    *p*."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::getComparisonOperator
"Accessor to the comparison operator.

Returns
-------
operator : :class:`~openturns.ComparisonOperator`
    The comparison operator."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::getInputSample
"Accessor to the input sample.

Returns
-------
inputSample : :class:`~openturns.Sample`
    The input sample."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::getOutputSample
"Accessor to the output sample.

Returns
-------
outputSample : :class:`~openturns.Sample`
    The output sample."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::getThreshold
"Accessor to the threshold.

Returns
-------
s : float
    The threshold."

// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::getTransformation
"Accessor to the isoprobabilistic transformation function.

Returns
-------
transformation : :class:`~openturns.Function`
    The isoprobabilistic transformation function."


// ---------------------------------------------------------------------

%feature("docstring") OT::SimulationSensitivityAnalysis::computeEventProbabilitySensitivity
"Compute the sensitivity to the probability.

The sensitivity of the probability Pf wrt the distribution parameters :math:`\\theta` is written:

.. math::

    \\vect{sens_{Pf}}_j = \\frac{1}{n} \\sum_{i=1}^n \\mathbf{1}_{event} \\vect{\\frac{\\delta log(f_{\\uX})(\\vect{X}_i)}{\\delta \\theta_j}}

Returns
-------
sensitivity_pf : :class:`~openturns.PointWithDescription`
    The probability sensitivity."

