
# -*- python; coding: utf-8 -*-
#
# gtk-doc - GTK DocBook documentation generator.
# Copyright (C) 2007  David Nečas
#               2007-2017  Stefan Sauer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

import argparse
import sys

try:
  import gtkdoc_uninstalled
except ModuleNotFoundError:
  sys.path.append(sys.prefix + '/share/gtk-doc/python')

from gtkdoc import common, check, config

if __name__ == '__main__':
    parser = argparse.ArgumentParser(
        description='gtkdoc-check version %s - run documentation unit tests' % config.version)
    parser.add_argument('--version', action='version', version=config.version)
    options = parser.parse_args()

    common.setup_logging()

    sys.exit(check.run(options))
