# Compute locations from <prefix>/@{LIBRARY_DIR@/cmake/lapacke-<v>/<self>.cmake
get_filename_component(_CBLAS_SELF_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# Load the LAPACK package with which we were built.
set(LAPACK_DIR "/mingw64/lib/cmake/lapack64-3.12.0")
find_package(LAPACK NO_MODULE)

# Load lapacke targets from the install tree.
if(NOT TARGET cblas64)
  include(${_CBLAS_SELF_DIR}/cblas64-targets.cmake)
endif()

# Report lapacke header search locations.
set(CBLAS_INCLUDE_DIRS /mingw64/include)

# Report lapacke libraries.
set(CBLAS_LIBRARIES cblas64)

unset(_CBLAS_SELF_DIR)
