
#ifndef ATTICA_EXPORT_H
#define ATTICA_EXPORT_H

#ifdef ATTICA_STATIC_DEFINE
#  define ATTICA_EXPORT
#  define ATTICA_NO_EXPORT
#else
#  ifndef ATTICA_EXPORT
#    ifdef KF5Attica_EXPORTS
        /* We are building this library */
#      define ATTICA_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define ATTICA_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef ATTICA_NO_EXPORT
#    define ATTICA_NO_EXPORT 
#  endif
#endif

#ifndef ATTICA_DECL_DEPRECATED
#  define ATTICA_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef ATTICA_DECL_DEPRECATED_EXPORT
#  define ATTICA_DECL_DEPRECATED_EXPORT ATTICA_EXPORT ATTICA_DECL_DEPRECATED
#endif

#ifndef ATTICA_DECL_DEPRECATED_NO_EXPORT
#  define ATTICA_DECL_DEPRECATED_NO_EXPORT ATTICA_NO_EXPORT ATTICA_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef ATTICA_NO_DEPRECATED
#    define ATTICA_NO_DEPRECATED
#  endif
#endif

#define ATTICA_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(ATTICA_NO_DEPRECATED) && !defined(ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define ATTICA_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(ATTICA_NO_DEPRECATED_WARNINGS) && !defined(ATTICA_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define ATTICA_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define ATTICA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(ATTICA_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define ATTICA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(ATTICA_NO_DEPRECATED)
#  undef ATTICA_DEPRECATED
#  define ATTICA_DEPRECATED_EXPORT ATTICA_EXPORT
#  define ATTICA_DEPRECATED_NO_EXPORT ATTICA_NO_EXPORT
#elif defined(ATTICA_NO_DEPRECATED_WARNINGS)
#  define ATTICA_DEPRECATED
#  define ATTICA_DEPRECATED_EXPORT ATTICA_EXPORT
#  define ATTICA_DEPRECATED_NO_EXPORT ATTICA_NO_EXPORT
#else
#  define ATTICA_DEPRECATED ATTICA_DECL_DEPRECATED
#  define ATTICA_DEPRECATED_EXPORT ATTICA_DECL_DEPRECATED_EXPORT
#  define ATTICA_DEPRECATED_NO_EXPORT ATTICA_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define ATTICA_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define ATTICA_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef ATTICA_NO_DEPRECATED
#  define ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57400
#endif
#ifdef ATTICA_NO_DEPRECATED_WARNINGS
#  define ATTICA_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef ATTICA_DEPRECATED_WARNINGS_SINCE
#  ifdef ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define ATTICA_DEPRECATED_WARNINGS_SINCE ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define ATTICA_DEPRECATED_WARNINGS_SINCE 0x57400
#  endif
#endif

#ifndef ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef ATTICA_DEPRECATED
#  define ATTICA_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > ATTICA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define ATTICA_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if ATTICA_DEPRECATED_WARNINGS_SINCE >= 0x200
#  define ATTICA_DEPRECATED_VERSION_0_2(text) ATTICA_DECL_DEPRECATED_TEXT(text)
#else
#  define ATTICA_DEPRECATED_VERSION_0_2(text)
#endif

#if ATTICA_DEPRECATED_WARNINGS_SINCE >= 0x50400
#  define ATTICA_DEPRECATED_VERSION_5_4(text) ATTICA_DECL_DEPRECATED_TEXT(text)
#else
#  define ATTICA_DEPRECATED_VERSION_5_4(text)
#endif

#if ATTICA_DEPRECATED_WARNINGS_SINCE >= 0x51700
#  define ATTICA_DEPRECATED_VERSION_5_23(text) ATTICA_DECL_DEPRECATED_TEXT(text)
#else
#  define ATTICA_DEPRECATED_VERSION_5_23(text)
#endif
#define ATTICA_DEPRECATED_VERSION_0(minor, text)      ATTICA_DEPRECATED_VERSION_0_##minor(text)
#define ATTICA_DEPRECATED_VERSION_5(minor, text)      ATTICA_DEPRECATED_VERSION_5_##minor(text)
#define ATTICA_DEPRECATED_VERSION(major, minor, text) ATTICA_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define ATTICA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) ATTICA_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define ATTICA_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) ATTICA_DEPRECATED_VERSION(major, minor, text)
#  define ATTICA_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) ATTICA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define ATTICA_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define ATTICA_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* ATTICA_EXPORT_H */
