pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Strings;
with Interfaces.C.Extensions;
with cevent_h;

package cfilter_h is

  -- * Copyright (c) 2014-2016 Enrico M. Crisostomo
  -- *
  -- * This program is free software; you can redistribute it and/or modify it under
  -- * the terms of the GNU General Public License as published by the Free Software
  -- * Foundation; either version 3, or (at your option) any later version.
  -- *
  -- * This program is distributed in the hope that it will be useful, but WITHOUT
  -- * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  -- * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  -- * details.
  -- *
  -- * You should have received a copy of the GNU General Public License along with
  -- * this program.  If not, see <http://www.gnu.org/licenses/>.
  --  

  --*
  -- * @file
  -- * @brief Header of the `libfswatch` library functions for filter management.
  -- *
  -- * @copyright Copyright (c) 2014-2016 Enrico M. Crisostomo
  -- * @license GNU General Public License v. 3.0
  -- * @author Enrico M. Crisostomo
  -- * @version 1.8.0
  --  

  --*
  --   * @brief Event filter type.
  --    

   type fsw_filter_type is 
     (filter_include,
      filter_exclude)
   with Convention => C;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:38

   type fsw_cmonitor_filter is record
      text : Interfaces.C.Strings.chars_ptr;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:46
      c_type : aliased fsw_filter_type;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:47
      case_sensitive : aliased Extensions.bool;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:48
      extended : aliased Extensions.bool;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:49
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:44

  --*
  --  * @brief Event type filter.
  --   

   type fsw_event_type_filter is record
      flag : aliased cevent_h.fsw_event_flag;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:57
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/mingw64/include/libfswatch/c/cfilter.h:55

end cfilter_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
