
#ifndef KCOLORSCHEME_EXPORT_H
#define KCOLORSCHEME_EXPORT_H

#ifdef KCOLORSCHEME_STATIC_DEFINE
#  define KCOLORSCHEME_EXPORT
#  define KCOLORSCHEME_NO_EXPORT
#else
#  ifndef KCOLORSCHEME_EXPORT
#    ifdef KF6ColorScheme_EXPORTS
        /* We are building this library */
#      define KCOLORSCHEME_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KCOLORSCHEME_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KCOLORSCHEME_NO_EXPORT
#    define KCOLORSCHEME_NO_EXPORT 
#  endif
#endif

#ifndef KCOLORSCHEME_DECL_DEPRECATED
#  define KCOLORSCHEME_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KCOLORSCHEME_DECL_DEPRECATED_EXPORT
#  define KCOLORSCHEME_DECL_DEPRECATED_EXPORT KCOLORSCHEME_EXPORT KCOLORSCHEME_DECL_DEPRECATED
#endif

#ifndef KCOLORSCHEME_DECL_DEPRECATED_NO_EXPORT
#  define KCOLORSCHEME_DECL_DEPRECATED_NO_EXPORT KCOLORSCHEME_NO_EXPORT KCOLORSCHEME_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCOLORSCHEME_NO_DEPRECATED
#    define KCOLORSCHEME_NO_DEPRECATED
#  endif
#endif
#include <kcolorscheme_version.h>

#define KCOLORSCHEME_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCOLORSCHEME_NO_DEPRECATED) && !defined(KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCOLORSCHEME_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCOLORSCHEME_NO_DEPRECATED_WARNINGS) && !defined(KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCOLORSCHEME_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCOLORSCHEME_NO_DEPRECATED)
#  undef KCOLORSCHEME_DEPRECATED
#  define KCOLORSCHEME_DEPRECATED_EXPORT KCOLORSCHEME_EXPORT
#  define KCOLORSCHEME_DEPRECATED_NO_EXPORT KCOLORSCHEME_NO_EXPORT
#elif defined(KCOLORSCHEME_NO_DEPRECATED_WARNINGS)
#  define KCOLORSCHEME_DEPRECATED
#  define KCOLORSCHEME_DEPRECATED_EXPORT KCOLORSCHEME_EXPORT
#  define KCOLORSCHEME_DEPRECATED_NO_EXPORT KCOLORSCHEME_NO_EXPORT
#else
#  define KCOLORSCHEME_DEPRECATED KCOLORSCHEME_DECL_DEPRECATED
#  define KCOLORSCHEME_DEPRECATED_EXPORT KCOLORSCHEME_DECL_DEPRECATED_EXPORT
#  define KCOLORSCHEME_DEPRECATED_NO_EXPORT KCOLORSCHEME_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCOLORSCHEME_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCOLORSCHEME_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCOLORSCHEME_NO_DEPRECATED
#  define KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT KCOLORSCHEME_VERSION
#endif
#ifdef KCOLORSCHEME_NO_DEPRECATED_WARNINGS
#  define KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE
#  ifdef KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE KCOLORSCHEME_VERSION
#  endif
#endif

#ifndef KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCOLORSCHEME_DEPRECATED
#  define KCOLORSCHEME_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCOLORSCHEME_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCOLORSCHEME_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCOLORSCHEME_DEPRECATED_WARNINGS_SINCE >= 0x60600
#  define KCOLORSCHEME_DEPRECATED_VERSION_6_6(text) KCOLORSCHEME_DECL_DEPRECATED_TEXT(text)
#else
#  define KCOLORSCHEME_DEPRECATED_VERSION_6_6(text)
#endif
#define KCOLORSCHEME_DEPRECATED_VERSION_6(minor, text)      KCOLORSCHEME_DEPRECATED_VERSION_6_##minor(text)
#define KCOLORSCHEME_DEPRECATED_VERSION(major, minor, text) KCOLORSCHEME_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCOLORSCHEME_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCOLORSCHEME_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCOLORSCHEME_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCOLORSCHEME_DEPRECATED_VERSION(major, minor, text)
#  define KCOLORSCHEME_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCOLORSCHEME_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCOLORSCHEME_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCOLORSCHEME_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCOLORSCHEME_EXPORT_H */
