#ifndef _CEGOOBJECTCURSOR_H_INCLUDED_
#define _CEGOOBJECTCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoObjectCursor.h
// ------------------
// Cego object cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoObjectCursor
// 
// Description: Basic cursor to trace on content objects 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoDefs.h"
#include "CegoLockHandler.h"
#include "CegoObjectManager.h"
#include "CegoDataPointer.h"

class CegoObjectManager;

class CegoObjectCursor {
    
public:
    
    CegoObjectCursor();
    CegoObjectCursor(CegoBufferPool *pOM, CegoLockHandler *pLockHandle, 
		     int tabSetId, 
		     CegoObject::ObjectType type,
		     PageIdType pageId);
    ~CegoObjectCursor();

    void setLastPageSync(bool doSync);
    
    void* getFirst(int& len, CegoDataPointer& dp);
    void* getNext(int& len, CegoDataPointer& dp);
    
    void abort();
    void reset();

    int getTabSetId();

 private:
    
    CegoBufferPool* _pBufPool;
    CegoLockHandler* _pLockHandle;
    CegoBufferPage _bp;
    CegoObject::ObjectType _type;
    int _tabSetId;
    PageIdType _pageId;
    unsigned long _lockId;
    unsigned long _recLock;
    bool _isEOC;
    PageIdType _startPageId;
    bool _lastPageSync;
    unsigned long _modId;
};

#endif
