/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.util.OSUtils;

public final class AboutPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(AboutPanel.class.getName());
    private static final String SITE_URL = "http://www.freecol.org";
    private static final String PROJECT_URL = "https://sourceforge.net/projects/freecol/";
    private static final String MANUAL_URL = "http://www.freecol.org/documentation/freecol-user-manual.html";
    private static final String GITHUB_URL = "https://github.com/FreeCol/freecol";

    public AboutPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new MigLayout("wrap"));
        JLabel apLogoLabel = new JLabel(new ImageIcon(ImageLibrary.getUnscaledImage("image.flavor.Title")));
        this.add((Component)apLogoLabel, "center");
        Font fontBold = FontLibrary.getScaledFont("normal-bold-tiny");
        Font fontNormal = FontLibrary.getScaledFont("normal-plain-tiny");
        JLabel apVersion = Utility.localizedLabel("aboutPanel.version");
        apVersion.setFont(fontBold);
        JLabel apRevision = new JLabel(FreeCol.getRevision());
        apRevision.setFont(fontNormal);
        this.add((Component)apVersion, "newline 20");
        this.add((Component)apRevision, "newline");
        JLabel apOfficialSite = Utility.localizedLabel("aboutPanel.officialSite");
        apOfficialSite.setFont(fontBold);
        this.add((Component)apOfficialSite, "newline 10");
        JButton apSiteURL = Utility.getLinkButton(SITE_URL, null, SITE_URL);
        apSiteURL.addActionListener(this);
        apSiteURL.setFont(fontNormal);
        this.add((Component)apSiteURL, "newline");
        JLabel apSFProject = Utility.localizedLabel("aboutPanel.sfProject");
        apSFProject.setFont(fontBold);
        this.add((Component)apSFProject, "newline 10");
        JButton apProjectURL = Utility.getLinkButton(PROJECT_URL, null, PROJECT_URL);
        apProjectURL.addActionListener(this);
        apProjectURL.setFont(fontNormal);
        this.add((Component)apProjectURL, "newline");
        JLabel apGitHubButton = Utility.localizedLabel("aboutPanel.github");
        apGitHubButton.setFont(fontBold);
        this.add((Component)apGitHubButton, "newline 10");
        JButton apGitHubURL = Utility.getLinkButton(GITHUB_URL, null, GITHUB_URL);
        apGitHubURL.addActionListener(this);
        apGitHubURL.setFont(fontNormal);
        this.add((Component)apGitHubURL, "newline");
        JLabel apManual = Utility.localizedLabel("aboutPanel.manual");
        apManual.setFont(fontBold);
        this.add((Component)apManual, "newline 10");
        JButton apManualURL = Utility.getLinkButton(MANUAL_URL, null, MANUAL_URL);
        apManualURL.addActionListener(this);
        this.add((Component)apManualURL, "newline");
        JTextArea apLegal = Utility.localizedTextArea("aboutPanel.legalDisclaimer");
        apLegal.setFont(fontNormal);
        this.add((Component)apLegal, "newline 20, width 300px");
        JLabel apCopyright = Utility.localizedLabel("aboutPanel.copyright");
        apCopyright.setFont(fontNormal);
        this.add((Component)apCopyright, "newline 10");
        this.add((Component)this.okButton, "newline 20, tag ok");
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AboutPanel.this.okButton.doClick();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String url = ae.getActionCommand();
        if (SITE_URL.equals(url) || PROJECT_URL.equals(url) || MANUAL_URL.equals(url) || GITHUB_URL.equals(url)) {
            OSUtils.launchBrowser(url);
        } else {
            super.actionPerformed(ae);
        }
    }
}

