/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.PrintWriter;
import java.text.ParseException;
import org.apache.catalina.ssi.ExpressionParseTree;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIConditionalState;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.ssi.SSIStopProcessingException;

public class SSIConditional
implements SSICommand {
    @Override
    public long process(SSIMediator sSIMediator, String string, String[] stringArray, String[] stringArray2, PrintWriter printWriter) throws SSIStopProcessingException {
        long l = System.currentTimeMillis();
        SSIConditionalState sSIConditionalState = sSIMediator.getConditionalState();
        if ("if".equalsIgnoreCase(string)) {
            if (sSIConditionalState.processConditionalCommandsOnly) {
                ++sSIConditionalState.nestingCount;
                return l;
            }
            sSIConditionalState.nestingCount = 0;
            if (this.evaluateArguments(stringArray, stringArray2, sSIMediator)) {
                sSIConditionalState.branchTaken = true;
            } else {
                sSIConditionalState.processConditionalCommandsOnly = true;
                sSIConditionalState.branchTaken = false;
            }
        } else if ("elif".equalsIgnoreCase(string)) {
            if (sSIConditionalState.nestingCount > 0) {
                return l;
            }
            if (sSIConditionalState.branchTaken) {
                sSIConditionalState.processConditionalCommandsOnly = true;
                return l;
            }
            if (this.evaluateArguments(stringArray, stringArray2, sSIMediator)) {
                sSIConditionalState.processConditionalCommandsOnly = false;
                sSIConditionalState.branchTaken = true;
            } else {
                sSIConditionalState.processConditionalCommandsOnly = true;
                sSIConditionalState.branchTaken = false;
            }
        } else if ("else".equalsIgnoreCase(string)) {
            if (sSIConditionalState.nestingCount > 0) {
                return l;
            }
            sSIConditionalState.processConditionalCommandsOnly = sSIConditionalState.branchTaken;
            sSIConditionalState.branchTaken = true;
        } else if ("endif".equalsIgnoreCase(string)) {
            if (sSIConditionalState.nestingCount > 0) {
                --sSIConditionalState.nestingCount;
                return l;
            }
            sSIConditionalState.processConditionalCommandsOnly = false;
            sSIConditionalState.branchTaken = true;
        } else {
            throw new SSIStopProcessingException();
        }
        return l;
    }

    private boolean evaluateArguments(String[] stringArray, String[] stringArray2, SSIMediator sSIMediator) throws SSIStopProcessingException {
        String string = this.getExpression(stringArray, stringArray2);
        if (string == null) {
            throw new SSIStopProcessingException();
        }
        try {
            ExpressionParseTree expressionParseTree = new ExpressionParseTree(string, sSIMediator);
            return expressionParseTree.evaluateTree();
        }
        catch (ParseException parseException) {
            throw new SSIStopProcessingException();
        }
    }

    private String getExpression(String[] stringArray, String[] stringArray2) {
        if ("expr".equalsIgnoreCase(stringArray[0])) {
            return stringArray2[0];
        }
        return null;
    }
}

