/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.promise.TriggerPromiseReactionsNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public class FulfillPromiseNode
extends JavaScriptBaseNode {
    @Node.Child
    private TriggerPromiseReactionsNode triggerPromiseReactions;

    protected FulfillPromiseNode(JSContext context) {
        this.triggerPromiseReactions = TriggerPromiseReactionsNode.create(context);
    }

    public static FulfillPromiseNode create(JSContext context) {
        return new FulfillPromiseNode(context);
    }

    public Object execute(JSPromiseObject promise, Object value) {
        assert (JSPromise.isPending(promise));
        SimpleArrayList<PromiseReactionRecord> reactions = promise.getPromiseFulfillReactions();
        promise.setPromiseResult(value);
        promise.clearPromiseReactions();
        JSPromise.setPromiseState(promise, 1);
        return this.triggerPromiseReactions.execute(reactions, value);
    }
}

