/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.ToPrimitiveBaseNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSObject;

@GenerateCached(value=false)
@GenerateInline
@GenerateUncached
@ImportStatic(value={JSConfig.class})
abstract class AsPrimitiveNode
extends ToPrimitiveBaseNode {
    AsPrimitiveNode() {
    }

    public abstract Object execute(Node var1, Object var2, JSToPrimitiveNode.Hint var3);

    @Specialization
    protected static Object doJSObject(Node node, JSObject object, JSToPrimitiveNode.Hint hint) {
        throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", node);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"})
    protected static Object doForeignObject(Node node, Object object, JSToPrimitiveNode.Hint hint, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached InlinedBranchProfile errorBranch, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncoding) {
        Object primitive = JSInteropUtil.toPrimitiveOrDefaultLossless(object, null, interop, switchEncoding, node);
        if (primitive != null) {
            return primitive;
        }
        errorBranch.enter(node);
        throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", node);
    }
}

