/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.OsEnvironGetNodeGen;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateCached(value=false)
public abstract class OsEnvironGetNode
extends PNodeWithContext {
    protected abstract TruffleString execute(TruffleString var1);

    public static TruffleString executeUncached(TruffleString name) {
        return OsEnvironGetNodeGen.getUncached().execute(name);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    static TruffleString doLookup(TruffleString name) {
        PythonModule os = AbstractImportNode.importModule(BuiltinNames.T_OS);
        Object environ = PyObjectGetAttr.executeUncached(os, BuiltinNames.T_ENVIRON);
        try {
            Object value = PyObjectGetItem.executeUncached(environ, name);
            return CastToTruffleStringNode.executeUncached(value);
        }
        catch (PException e) {
            e.expectUncached(PythonErrorType.KeyError);
        }
        catch (CannotCastException cannotCastException) {
            // empty catch block
        }
        return null;
    }
}

