/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFDCNConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;

class NTFDCNConnectionGroup
implements Monitor {
    private static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS;
    private ArrayList<NTFDCNConnection> dcnListenerConnections = new ArrayList();
    private final String groupId;
    private int noOfRegistrationsInThisGroup = 0;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    NTFDCNConnectionGroup(String groupId) {
        this.groupId = groupId;
    }

    NTFDCNConnection getNTFDCNConnection() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ++this.noOfRegistrationsInThisGroup;
            if (this.noOfRegistrationsInThisGroup > MAX_NTF_CONNECTIONS) {
                int minimumRegistrations = this.noOfRegistrationsInThisGroup;
                NTFDCNConnection connectionWithMinimumRegistrations = this.dcnListenerConnections.get(0);
                for (NTFDCNConnection listenerConnection : this.dcnListenerConnections) {
                    int numberOfRegistrationsInConnection = listenerConnection.getNumberOfRegistrations();
                    if (numberOfRegistrationsInConnection >= minimumRegistrations) continue;
                    connectionWithMinimumRegistrations = listenerConnection;
                    minimumRegistrations = numberOfRegistrationsInConnection;
                }
                connectionWithMinimumRegistrations.incrementNumberOfRegistrations(1);
                NTFDCNConnection nTFDCNConnection = connectionWithMinimumRegistrations;
                return nTFDCNConnection;
            }
            NTFDCNConnection nTFDCNConnection = null;
            return nTFDCNConnection;
        }
    }

    void startDCNListenerConnection(String instanceName, String serviceName, String userName, OpaqueString password, Properties extrAuthProp, ArrayList<String> listenerAddresses, String clientId, int numberOfRegistrations) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            assert (clientId != null) : "dcnConnectionId is null";
            String connClass = "notify" + clientId;
            NTFDCNConnection dcnListenerConnection = new NTFDCNConnection(clientId, listenerAddresses, instanceName, serviceName, userName, password, extrAuthProp, connClass, numberOfRegistrations);
            this.dcnListenerConnections.add(dcnListenerConnection);
            dcnListenerConnection.setDaemon(true);
            dcnListenerConnection.start();
        }
    }

    void stopNTFDCNConnection(String clientId) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (clientId == null || clientId.length() == 0) {
                return;
            }
            for (NTFDCNConnection listenerConnection : this.dcnListenerConnections) {
                if (listenerConnection == null || !clientId.equals(listenerConnection.getClientId())) continue;
                listenerConnection.decrementNumberOfRegistrations(1);
                if (listenerConnection.getNumberOfRegistrations() <= 0) {
                    listenerConnection.setNeedToBeClosed(true);
                }
                break;
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    static {
        try {
            $$$methodRef$$$4 = NTFDCNConnectionGroup.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFDCNConnectionGroup.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNConnectionGroup.class.getDeclaredMethod("stopNTFDCNConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNConnectionGroup.class.getDeclaredMethod("startDCNListenerConnection", String.class, String.class, String.class, OpaqueString.class, Properties.class, ArrayList.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNConnectionGroup.class.getDeclaredMethod("getNTFDCNConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        MAX_NTF_CONNECTIONS = 16;
    }
}

