/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictViewBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.DictViewBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictItemsView})
public final class DictViewBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DictViewBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictViewBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.nb_xor, isComplex=true)
    @GenerateNodeFactory
    public static abstract class XorNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        @Specialization
        static PBaseSet doGeneric(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached GetStorageForBinopNode getStorage, @Cached HashingStorageNodes.HashingStorageXor xor, @Bind PythonLanguage language) {
            HashingStorage left = getStorage.execute((Frame)frame, inliningTarget, self);
            HashingStorage right = getStorage.execute((Frame)frame, inliningTarget, other);
            return PFactory.createSet(language, xor.execute((Frame)frame, inliningTarget, left, right));
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    public static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        @Specialization
        static PBaseSet doGeneric(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached GetCopiedStorageForBinopNode getStorage, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Bind PythonLanguage language) {
            HashingStorage left = getStorage.execute((Frame)frame, inliningTarget, self);
            HashingStorage right = getStorage.execute((Frame)frame, inliningTarget, other);
            return PFactory.createSet(language, addAllToOther.execute((Frame)frame, inliningTarget, left, right));
        }
    }

    @Slot(value=Slot.SlotKind.nb_and, isComplex=true)
    @GenerateNodeFactory
    static abstract class AndNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        AndNode() {
        }

        @Specialization
        static PBaseSet doGeneric(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached GetStorageForBinopNode getStorage, @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Bind PythonLanguage language) {
            HashingStorage left = getStorage.execute((Frame)frame, inliningTarget, self);
            HashingStorage right = getStorage.execute((Frame)frame, inliningTarget, other);
            return PFactory.createSet(language, intersectNode.execute((Frame)frame, inliningTarget, left, right));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetCopiedStorageForBinopNode
    extends Node {
        GetCopiedStorageForBinopNode() {
        }

        public abstract HashingStorage execute(Frame var1, Node var2, Object var3);

        @Specialization
        static HashingStorage doView(Node inliningTarget, PDictView.PDictKeysView obj, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
            return copyNode.execute(inliningTarget, obj.getWrappedStorage());
        }

        @Specialization
        static HashingStorage doSet(Node inliningTarget, PBaseSet obj, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
            return copyNode.execute(inliningTarget, obj.getDictStorage());
        }

        @Fallback
        static HashingStorage doOther(VirtualFrame frame, Object obj, @Cached SetNodes.ConstructSetNode constructSetNode) {
            return constructSetNode.execute((Frame)frame, obj).getDictStorage();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetStorageForBinopNode
    extends Node {
        GetStorageForBinopNode() {
        }

        public abstract HashingStorage execute(Frame var1, Node var2, Object var3);

        @Specialization
        static HashingStorage doView(PDictView.PDictKeysView obj) {
            return obj.getWrappedStorage();
        }

        @Specialization
        static HashingStorage doSet(PBaseSet obj) {
            return obj.getDictStorage();
        }

        @Fallback
        static HashingStorage doOther(VirtualFrame frame, Object obj, @Cached SetNodes.ConstructSetNode constructSetNode) {
            return constructSetNode.execute((Frame)frame, obj).getDictStorage();
        }
    }

    @Slot(value=Slot.SlotKind.nb_subtract, isComplex=true)
    @GenerateNodeFactory
    static abstract class SubNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        SubNode() {
        }

        @Specialization
        static PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PBaseSet other, @Bind Node inliningTarget, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, self.getWrappedStorage(), other.getDictStorage());
            return PFactory.createSet(language, storage);
        }

        @Specialization
        static PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, PDictView.PDictKeysView other, @Bind Node inliningTarget, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, self.getWrappedStorage(), other.getWrappedStorage());
            return PFactory.createSet(language, storage);
        }

        @Specialization
        static PBaseSet doKeysView(VirtualFrame frame, PDictView.PDictKeysView self, Object other, @Bind Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage left = self.getWrappedStorage();
            HashingStorage right = constructSetNode.execute((Frame)frame, other).getDictStorage();
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left, right);
            return PFactory.createSet(language, storage);
        }

        @Specialization
        static PBaseSet doItemsView(VirtualFrame frame, PDictView.PDictItemsView self, PBaseSet other, @Bind Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            PSet selfSet = constructSetNode.execute((Frame)frame, self);
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, selfSet.getDictStorage(), other.getDictStorage());
            return PFactory.createSet(language, storage);
        }

        @Specialization
        static PBaseSet doGeneric(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached.Shared(value="constrSet") @Cached SetNodes.ConstructSetNode constructSetNode, @Cached.Shared(value="diff") @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage left = constructSetNode.execute((Frame)frame, self).getDictStorage();
            HashingStorage right = constructSetNode.execute((Frame)frame, other).getDictStorage();
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left, right);
            return PFactory.createSet(language, storage);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class DictViewRichcompareHelperNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        DictViewRichcompareHelperNode() {
        }

        protected static boolean reverse(RichCmpOp op) {
            return op == RichCmpOp.Py_GE || op == RichCmpOp.Py_GT;
        }

        static boolean isDictViewOrSet(Object o) {
            return o instanceof PDictView || o instanceof PBaseSet;
        }

        @Specialization(guards={"isDictViewOrSet(other)"})
        static boolean doIt(VirtualFrame frame, PDictView self, Object other, RichCmpOp originalOp, @Bind Node inliningTarget, @Cached InlinedConditionProfile isSetProfile, @Cached InlinedConditionProfile lenCheckProfile, @Cached InlinedConditionProfile reverseProfile, @Cached HashingStorageNodes.HashingStorageLen selfLenNode, @Cached HashingStorageNodes.HashingStorageLen otherLenNode, @Cached ContainedInNode allContained) {
            HashingStorage otherStorage;
            int lenOther;
            int lenSelf;
            RichCmpOp op = originalOp != RichCmpOp.Py_NE ? originalOp : RichCmpOp.Py_EQ;
            if (lenCheckProfile.profile(inliningTarget, !op.compareResultToBool((lenSelf = selfLenNode.execute(inliningTarget, self.getWrappedStorage())) - (lenOther = otherLenNode.execute(inliningTarget, otherStorage = isSetProfile.profile(inliningTarget, other instanceof PBaseSet) ? ((PBaseSet)other).getDictStorage() : ((PDictView)other).getWrappedStorage()))))) {
                return originalOp == RichCmpOp.Py_NE;
            }
            Object left = self;
            Object right = other;
            if (reverseProfile.profile(inliningTarget, DictViewRichcompareHelperNode.reverse(op))) {
                left = other;
                right = self;
            }
            boolean result = allContained.execute(frame, left, right);
            if (originalOp == RichCmpOp.Py_NE) {
                result = !result;
            }
            return result;
        }

        @Fallback
        static PNotImplemented wrongTypes(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    protected static abstract class ContainedInNode
    extends PNodeWithContext {
        private final boolean checkAll;

        public ContainedInNode(boolean checkAll) {
            this.checkAll = checkAll;
        }

        public abstract boolean execute(VirtualFrame var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public boolean doIt(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached PyObjectGetIter getIterNode, @Cached PyIterNextNode nextNode, @Cached PySequenceContainsNode containsNode, @Cached PyObjectIsTrueNode isTrueNode) {
            Object iterator = getIterNode.execute((Frame)frame, inliningTarget, self);
            boolean ok = this.checkAll;
            int i = 0;
            try {
                while (loopConditionProfile.profile(inliningTarget, this.checkAll && ok || !this.checkAll && !ok)) {
                    Object item;
                    try {
                        item = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    }
                    catch (IteratorExhausted e) {
                        break;
                    }
                    ok = isTrueNode.execute((Frame)frame, containsNode.execute((Frame)frame, inliningTarget, other, item));
                    ++i;
                }
                LoopNode.reportLoopCount((Node)this, (int)(i < 0 ? Integer.MAX_VALUE : i));
            }
            catch (Throwable throwable) {
                LoopNode.reportLoopCount((Node)this, (int)(i < 0 ? Integer.MAX_VALUE : i));
                throw throwable;
            }
            return ok;
        }

        @NeverDefault
        static ContainedInNode create() {
            return DictViewBuiltinsFactory.ContainedInNodeGen.create(true);
        }

        @NeverDefault
        static ContainedInNode create(boolean all) {
            return DictViewBuiltinsFactory.ContainedInNodeGen.create(all);
        }
    }

    @Builtin(name="isdisjoint", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IsDisjointNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"self == other"})
        static boolean disjointSame(PDictView self, PDictView other, @Bind Node inliningTarget, @Cached @Cached.Shared HashingStorageNodes.HashingStorageLen len) {
            return len.execute(inliningTarget, self.getWrappedStorage()) == 0;
        }

        @Specialization(guards={"self != other"})
        static boolean disjointNotSame(VirtualFrame frame, PDictView self, PDictView other, @Bind Node inliningTarget, @Cached @Cached.Shared HashingStorageNodes.HashingStorageLen len, @Cached @Cached.Shared InlinedConditionProfile sizeProfile, @Cached @Cached.Shared PyObjectSizeNode sizeNode, @Cached(value="create(false)") @Cached.Shared ContainedInNode contained) {
            return IsDisjointNode.disjointImpl(frame, inliningTarget, self, other, len, sizeProfile, sizeNode, contained);
        }

        @Specialization
        static boolean disjoint(VirtualFrame frame, PDictView self, PBaseSet other, @Bind Node inliningTarget, @Cached @Cached.Shared HashingStorageNodes.HashingStorageLen len, @Cached @Cached.Shared InlinedConditionProfile sizeProfile, @Cached @Cached.Shared PyObjectSizeNode sizeNode, @Cached(value="create(false)") @Cached.Shared ContainedInNode contained) {
            return IsDisjointNode.disjointImpl(frame, inliningTarget, self, other, len, sizeProfile, sizeNode, contained);
        }

        private static boolean disjointImpl(VirtualFrame frame, Node inliningTarget, PDictView self, Object other, HashingStorageNodes.HashingStorageLen len, InlinedConditionProfile sizeProfile, PyObjectSizeNode sizeNode, ContainedInNode contained) {
            if (sizeProfile.profile(inliningTarget, len.execute(inliningTarget, self.getWrappedStorage()) <= sizeNode.execute((Frame)frame, inliningTarget, other))) {
                return !contained.execute(frame, self, other);
            }
            return !contained.execute(frame, other, self);
        }

        @Specialization(guards={"!isAnySet(other)", "!isDictView(other)"})
        static boolean disjoint(VirtualFrame frame, PDictView self, Object other, @Cached(value="create(false)") @Cached.Shared ContainedInNode contained) {
            return !contained.execute(frame, other, self);
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        @Specialization(guards={"len.execute(inliningTarget, self.getWrappedStorage()) == 0"}, limit="1")
        static boolean containsEmpty(PDictView self, Object key, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen len) {
            return false;
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PDictView.PDictKeysView self, Object key, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return getItem.hasKey((Frame)frame, inliningTarget, self.getWrappedStorage(), key);
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PDictView.PDictItemsView self, PTuple key, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PyObjectRichCompareBool eqNode, @Cached InlinedConditionProfile tupleLenProfile, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getTupleItemNode) {
            SequenceStorage tupleStorage = key.getSequenceStorage();
            if (tupleLenProfile.profile(inliningTarget, tupleStorage.length() != 2)) {
                return false;
            }
            HashingStorage dictStorage = self.getWrappedStorage();
            Object value = getItem.execute((Frame)frame, inliningTarget, dictStorage, getTupleItemNode.execute(tupleStorage, 0));
            if (value != null) {
                return eqNode.execute((Frame)frame, inliningTarget, value, getTupleItemNode.execute(tupleStorage, 1), RichCmpOp.Py_EQ);
            }
            return false;
        }

        protected static boolean isFallback(Object self, Object key) {
            return !(self instanceof PDictView) || self instanceof PDictView.PDictItemsView && !(key instanceof PTuple);
        }

        @Specialization(guards={"isFallback(self, key)"})
        static boolean contains(Object self, Object key) {
            return false;
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getReversedKeysViewIter(PDictView.PDictKeysView self, @Bind Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIterator, @Bind PythonLanguage language) {
            HashingStorage storage = self.getWrappedStorage();
            return PFactory.createDictKeyIterator(language, getReverseIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }

        @Specialization
        static Object getReversedItemsViewIter(PDictView.PDictItemsView self, @Bind Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIterator, @Bind PythonLanguage language) {
            HashingStorage storage = self.getWrappedStorage();
            return PFactory.createDictItemIterator(language, getReverseIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getKeysViewIter(PDictView.PDictKeysView self, @Bind Node inliningTarget, @Cached.Shared(value="len") @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared(value="getit") @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Bind PythonLanguage language) {
            HashingStorage storage = self.getWrappedStorage();
            return PFactory.createDictKeyIterator(language, getIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }

        @Specialization
        static Object getItemsViewIter(PDictView.PDictItemsView self, @Bind Node inliningTarget, @Cached.Shared(value="len") @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared(value="getit") @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Bind PythonLanguage language) {
            HashingStorage storage = self.getWrappedStorage();
            return PFactory.createDictItemIterator(language, getIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.sq_length)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        static int len(PDictView self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen len) {
            return len.execute(inliningTarget, self.getWrappedStorage());
        }
    }

    @Builtin(name="mapping", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MappingNode
    extends PythonUnaryBuiltinNode {
        MappingNode() {
        }

        @Specialization
        static Object mapping(PDictView self, @Bind PythonLanguage language) {
            return PFactory.createMappingproxy(language, self.getWrappedDict());
        }
    }
}

