/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstLiteralExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstNumericLiteralExpression
extends PyAstLiteralExpression {
    @Nullable
    default public Long getLongValue() {
        BigInteger value = this.getBigIntegerValue();
        long longValue = value.longValue();
        return BigInteger.valueOf(longValue).equals(value) ? Long.valueOf(longValue) : null;
    }

    @NotNull
    default public BigInteger getBigIntegerValue() {
        if (this.isIntegerLiteral()) {
            return PyAstNumericLiteralExpression.getBigIntegerValue(this.getNode().getText());
        }
        BigDecimal bigDecimal = this.getBigDecimalValue();
        BigInteger bigInteger = bigDecimal.toBigInteger();
        if (bigInteger == null) {
            PyAstNumericLiteralExpression.$$$reportNull$$$0(0);
        }
        return bigInteger;
    }

    @NotNull
    default public BigDecimal getBigDecimalValue() {
        String text = this.getNode().getText();
        return this.isIntegerLiteral() ? new BigDecimal(PyAstNumericLiteralExpression.getBigIntegerValue(text)) : new BigDecimal(PyAstNumericLiteralExpression.prepareLiteralForJava(text, 0));
    }

    default public boolean isIntegerLiteral() {
        return this.getNode().getElementType() == PyElementTypes.INTEGER_LITERAL_EXPRESSION;
    }

    @Nullable
    default public String getIntegerLiteralSuffix() {
        return this.isIntegerLiteral() ? StringUtil.nullize((String)PyAstNumericLiteralExpression.retrieveSuffix(this.getText())) : null;
    }

    @NotNull
    private static BigInteger getBigIntegerValue(@NotNull String text) {
        int radix;
        int beginIndex;
        if (text == null) {
            PyAstNumericLiteralExpression.$$$reportNull$$$0(1);
        }
        if (text.equalsIgnoreCase("0" + PyAstNumericLiteralExpression.retrieveSuffix(text))) {
            BigInteger bigInteger = BigInteger.ZERO;
            if (bigInteger == null) {
                PyAstNumericLiteralExpression.$$$reportNull$$$0(2);
            }
            return bigInteger;
        }
        if (StringUtil.startsWithIgnoreCase((String)text, (String)"0x")) {
            beginIndex = 2;
            radix = 16;
        } else if (StringUtil.startsWithIgnoreCase((String)text, (String)"0b")) {
            beginIndex = 2;
            radix = 2;
        } else if (text.startsWith("0")) {
            beginIndex = StringUtil.isChar((CharSequence)text, (int)1, (char)'o') || StringUtil.isChar((CharSequence)text, (int)1, (char)'O') ? 2 : 1;
            radix = 8;
        } else {
            beginIndex = 0;
            radix = 10;
        }
        return new BigInteger(PyAstNumericLiteralExpression.prepareLiteralForJava(text, beginIndex), radix);
    }

    @NotNull
    private static String prepareLiteralForJava(@NotNull String text, int beginIndex) {
        if (text == null) {
            PyAstNumericLiteralExpression.$$$reportNull$$$0(3);
        }
        int endIndex = text.length() - PyAstNumericLiteralExpression.retrieveSuffix(text).length();
        StringBuilder result2 = new StringBuilder(endIndex - beginIndex);
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = text.charAt(i);
            if (c == '_') continue;
            result2.append(c);
        }
        String string = result2.toString();
        if (string == null) {
            PyAstNumericLiteralExpression.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String retrieveSuffix(@NotNull String text) {
        char last;
        int lastIndex;
        if (text == null) {
            PyAstNumericLiteralExpression.$$$reportNull$$$0(5);
        }
        for (lastIndex = text.length(); lastIndex > 0 && ((last = text.charAt(lastIndex - 1)) == 'u' || last == 'U' || last == 'l' || last == 'L' || last == 'j' || last == 'J'); --lastIndex) {
        }
        String string = text.substring(lastIndex);
        if (string == null) {
            PyAstNumericLiteralExpression.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyNumericLiteralExpression(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstNumericLiteralExpression";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIntegerValue";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstNumericLiteralExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLiteralForJava";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBigIntegerValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareLiteralForJava";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "retrieveSuffix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

