"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sqlPlugin;
var _constants = require("../../services/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function sqlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.sql = components.clientAction.namespaceFactory();
  const sql = Client.prototype.sql.prototype;
  sql.translateSQL = ca({
    url: {
      fmt: `${_constants.SQL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.translatePPL = ca({
    url: {
      fmt: `${_constants.PPL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlQuery = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.pplQuery = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.sqlCsv = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplCsv = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlText = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplText = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sparkSqlQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sparkSqlGetQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}/<%=jobId%>`,
      req: {
        jobId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  sql.datasourcesGetQuery = ca({
    url: {
      fmt: `${_constants.DATASOURCES_GET_QUERY}`
    },
    needBody: false,
    method: 'GET'
  });
  sql.asyncDeleteQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}/<%=jobId%>`,
      req: {
        jobId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'DELETE'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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