/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.WebAuthnAuthenticationManager;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.verifier.OriginVerifier;
import com.webauthn4j.verifier.OriginVerifierImpl;
import com.webauthn4j.verifier.exception.BadOriginException;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authentication.authenticators.browser.WebAuthnMetadataService;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Time;
import org.keycloak.credential.AttestationStatementConverter;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialMetadata;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialPublicKeyConverter;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.WebAuthnCredentialModelInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.credential.WebAuthnCredentialModel;
import org.keycloak.models.credential.dto.WebAuthnCredentialData;
import org.keycloak.models.credential.dto.WebAuthnCredentialPresentationData;
import org.keycloak.models.credential.dto.WebAuthnSecretData;
import org.keycloak.util.JsonSerialization;

public class WebAuthnCredentialProvider
implements CredentialProvider<WebAuthnCredentialModel>,
CredentialInputValidator {
    private static final Logger logger = Logger.getLogger(WebAuthnCredentialProvider.class);
    private static final String WEBAUTHN_AUTHENTICATOR_PROVIDER = "webauthn-authenticator-provider";
    private static final String WEBAUTHN_TRANSPORTS = "webauthn-transports";
    private final KeycloakSession session;
    private final WebAuthnMetadataService metadataService;
    private final CredentialPublicKeyConverter credentialPublicKeyConverter;
    private final AttestationStatementConverter attestationStatementConverter;

    public WebAuthnCredentialProvider(KeycloakSession session, WebAuthnMetadataService metadataService, ObjectConverter objectConverter) {
        this.session = session;
        this.metadataService = metadataService;
        this.credentialPublicKeyConverter = new CredentialPublicKeyConverter(objectConverter);
        this.attestationStatementConverter = new AttestationStatementConverter(objectConverter);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, WebAuthnCredentialModel credentialModel) {
        if (credentialModel.getCreatedDate() == null) {
            credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        }
        return user.credentialManager().createStoredCredential((CredentialModel)credentialModel);
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        logger.debugv("Delete WebAuthn credential. username = {0}, credentialId = {1}", (Object)user.getUsername(), (Object)credentialId);
        return user.credentialManager().removeStoredCredentialById(credentialId);
    }

    public WebAuthnCredentialModel getCredentialFromModel(CredentialModel model) {
        return WebAuthnCredentialModel.createFromCredentialModel((CredentialModel)model);
    }

    public WebAuthnCredentialModel getCredentialForPresentationFromModel(CredentialModel model) {
        WebAuthnCredentialModel origCredential = this.getCredentialFromModel(model);
        WebAuthnCredentialData data = origCredential.getWebAuthnCredentialData();
        String authenticatorProvider = this.metadataService.getAuthenticatorProvider(data.getAaguid());
        if (authenticatorProvider == null) {
            return origCredential;
        }
        WebAuthnCredentialPresentationData presentationData = new WebAuthnCredentialPresentationData(data.getAaguid(), data.getCredentialId(), data.getCounter(), data.getAttestationStatement(), data.getCredentialPublicKey(), data.getAttestationStatementFormat(), data.getTransports(), authenticatorProvider);
        return WebAuthnCredentialModel.create((String)origCredential.getId(), (String)origCredential.getType(), (Long)origCredential.getCreatedDate(), (String)origCredential.getUserLabel(), (WebAuthnCredentialData)presentationData, (WebAuthnSecretData)origCredential.getWebAuthnSecretData());
    }

    public WebAuthnCredentialModel getCredentialModelFromCredentialInput(CredentialInput input, String userLabel) {
        if (!this.supportsCredentialType(input.getType())) {
            return null;
        }
        WebAuthnCredentialModelInput webAuthnModel = (WebAuthnCredentialModelInput)input;
        String aaguid = webAuthnModel.getAttestedCredentialData().getAaguid().toString();
        String credentialId = Base64.encodeBytes((byte[])webAuthnModel.getAttestedCredentialData().getCredentialId());
        String credentialPublicKey = this.credentialPublicKeyConverter.convertToDatabaseColumn(webAuthnModel.getAttestedCredentialData().getCOSEKey());
        long counter = webAuthnModel.getCount();
        String attestationStatementFormat = webAuthnModel.getAttestationStatementFormat();
        Set transports = webAuthnModel.getTransports().stream().map(AuthenticatorTransport::getValue).collect(Collectors.toSet());
        WebAuthnCredentialModel model = WebAuthnCredentialModel.create((String)this.getType(), (String)userLabel, (String)aaguid, (String)credentialId, null, (String)credentialPublicKey, (long)counter, (String)attestationStatementFormat, transports);
        model.setId(webAuthnModel.getCredentialDBId());
        return model;
    }

    private WebAuthnCredentialModelInput getCredentialInputFromCredentialModel(CredentialModel credential) {
        WebAuthnCredentialModel webAuthnCredential = this.getCredentialFromModel(credential);
        WebAuthnCredentialData credData = webAuthnCredential.getWebAuthnCredentialData();
        WebAuthnCredentialModelInput auth = new WebAuthnCredentialModelInput(this.getType());
        byte[] credentialId = null;
        try {
            credentialId = Base64.decode((String)credData.getCredentialId());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AAGUID aaguid = new AAGUID(credData.getAaguid());
        COSEKey pubKey = this.credentialPublicKeyConverter.convertToEntityAttribute(credData.getCredentialPublicKey());
        AttestedCredentialData attrCredData = new AttestedCredentialData(aaguid, credentialId, pubKey);
        auth.setAttestedCredentialData(attrCredData);
        long count = credData.getCounter();
        auth.setCount(count);
        auth.setCredentialDBId(credential.getId());
        auth.setAttestationStatementFormat(credData.getAttestationStatementFormat());
        return auth;
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return user.credentialManager().getStoredCredentialsByTypeStream(credentialType).count() > 0L;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!WebAuthnCredentialModelInput.class.isInstance(input)) {
            return false;
        }
        WebAuthnCredentialModelInput context = (WebAuthnCredentialModelInput)WebAuthnCredentialModelInput.class.cast(input);
        List<WebAuthnCredentialModelInput> auths = this.getWebAuthnCredentialModelList(realm, user);
        WebAuthnAuthenticationManager webAuthnAuthenticationManager = this.getWebAuthnAuthenticationManager();
        AuthenticationData authenticationData = null;
        try {
            for (WebAuthnCredentialModelInput auth : auths) {
                byte[] credentialId = auth.getAttestedCredentialData().getCredentialId();
                if (!Arrays.equals(credentialId, context.getAuthenticationRequest().getCredentialId())) continue;
                AuthenticatorImpl authenticator = new AuthenticatorImpl(auth.getAttestedCredentialData(), auth.getAttestationStatement(), auth.getCount());
                authenticationData = webAuthnAuthenticationManager.parse(context.getAuthenticationRequest());
                AuthenticationParameters authenticationParameters = new AuthenticationParameters(context.getAuthenticationParameters().getServerProperty(), (Authenticator)authenticator, context.getAuthenticationParameters().isUserVerificationRequired());
                webAuthnAuthenticationManager.verify(authenticationData, authenticationParameters);
                logger.debugv("response.getAuthenticatorData().getFlags() = {0}", (Object)authenticationData.getAuthenticatorData().getFlags());
                CredentialModel credModel = user.credentialManager().getStoredCredentialById(auth.getCredentialDBId());
                WebAuthnCredentialModel webAuthnCredModel = this.getCredentialFromModel(credModel);
                long count = auth.getCount();
                if (count > 0L) {
                    webAuthnCredModel.updateCounter(count + 1L);
                    user.credentialManager().updateStoredCredential((CredentialModel)webAuthnCredModel);
                }
                logger.debugf("Successfully validated WebAuthn credential for user %s", (Object)user.getUsername());
                this.dumpCredentialModel(webAuthnCredModel, auth);
                return true;
            }
        }
        catch (WebAuthnException wae) {
            wae.printStackTrace();
            throw wae;
        }
        return false;
    }

    protected WebAuthnAuthenticationManager getWebAuthnAuthenticationManager() {
        WebAuthnPolicy policy = this.getWebAuthnPolicy();
        final Set origins = policy.getExtraOrigins().stream().map(Origin::new).collect(Collectors.toSet());
        WebAuthnAuthenticationManager webAuthnAuthenticationManager = new WebAuthnAuthenticationManager();
        webAuthnAuthenticationManager.getAuthenticationDataVerifier().setOriginVerifier((OriginVerifier)new OriginVerifierImpl(){

            protected void verify(@Nonnull CollectedClientData collectedClientData, @Nonnull ServerProperty serverProperty) {
                AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
                AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
                Origin clientOrigin = collectedClientData.getOrigin();
                if (serverProperty.getOrigins().contains(clientOrigin)) {
                    return;
                }
                if (origins.contains(clientOrigin)) {
                    return;
                }
                throw new BadOriginException("The collectedClientData '" + String.valueOf(clientOrigin) + "' origin doesn't match any of the preconfigured origins.");
            }
        });
        return webAuthnAuthenticationManager;
    }

    protected WebAuthnPolicy getWebAuthnPolicy() {
        return this.session.getContext().getRealm().getWebAuthnPolicy();
    }

    public String getType() {
        return "webauthn";
    }

    private List<WebAuthnCredentialModelInput> getWebAuthnCredentialModelList(RealmModel realm, UserModel user) {
        return user.credentialManager().getStoredCredentialsByTypeStream(this.getType()).map(this::getCredentialInputFromCredentialModel).collect(Collectors.toList());
    }

    public void dumpCredentialModel(WebAuthnCredentialModel credential, WebAuthnCredentialModelInput auth) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Persisted Credential Info::");
            logger.debug((Object)credential);
            logger.debug((Object)"  Context Credential Info::");
            logger.debug((Object)auth);
        }
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("webauthn-display-name").helpText("webauthn-help-text").iconCssClass("kcAuthenticatorWebAuthnClass").createAction("webauthn-register").removeable(true).build(this.session);
    }

    protected KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public CredentialMetadata getCredentialMetadata(WebAuthnCredentialModel credentialModel, CredentialTypeMetadata credentialTypeMetadata) {
        CredentialMetadata credentialMetadata = new CredentialMetadata();
        LinkedList<CredentialMetadata.LocalizedMessage> properties = new LinkedList<CredentialMetadata.LocalizedMessage>();
        try {
            credentialModel = this.getCredentialForPresentationFromModel((CredentialModel)credentialModel);
            WebAuthnCredentialPresentationData credentialData = (WebAuthnCredentialPresentationData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), WebAuthnCredentialPresentationData.class);
            Set transports = credentialData.getTransports();
            if (credentialData.getAuthenticatorProvider() != null) {
                properties.add(new CredentialMetadata.LocalizedMessage(WEBAUTHN_AUTHENTICATOR_PROVIDER, (Object[])new String[]{credentialData.getAuthenticatorProvider()}));
            }
            if (transports != null && !transports.isEmpty()) {
                String joinedTransports = String.join((CharSequence)", ", transports);
                properties.add(new CredentialMetadata.LocalizedMessage(WEBAUTHN_TRANSPORTS, (Object[])new String[]{joinedTransports}));
            }
            if (!properties.isEmpty()) {
                credentialMetadata.setInfoProperties(properties);
            }
        }
        catch (IOException e) {
            logger.warn((Object)"unable to deserialize model information, skipping messages", (Throwable)e);
        }
        credentialMetadata.setCredentialModel((CredentialModel)credentialModel);
        return credentialMetadata;
    }
}

