/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.credential.CoreCredentialRecord;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreAuthenticationParameters {
    private final CoreServerProperty serverProperty;
    private final CoreAuthenticator authenticator;
    private final List<byte[]> allowCredentials;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;

    public CoreAuthenticationParameters(@NotNull CoreServerProperty serverProperty, @NotNull CoreCredentialRecord coreCredentialRecord, @Nullable List<byte[]> allowCredentials, boolean userVerificationRequired, boolean userPresenceRequired) {
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        AssertUtil.notNull(coreCredentialRecord, "coreCredentialRecord must not be null");
        this.serverProperty = serverProperty;
        this.authenticator = coreCredentialRecord;
        this.allowCredentials = CollectionUtil.unmodifiableList(allowCredentials);
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    public CoreAuthenticationParameters(@NotNull CoreServerProperty serverProperty, @NotNull CoreCredentialRecord coreCredentialRecord, @Nullable List<byte[]> allowCredentials, boolean userVerificationRequired) {
        this(serverProperty, coreCredentialRecord, allowCredentials, userVerificationRequired, true);
    }

    @Deprecated
    public CoreAuthenticationParameters(@NotNull CoreServerProperty serverProperty, @NotNull CoreAuthenticator authenticator, @Nullable List<byte[]> allowCredentials, boolean userVerificationRequired, boolean userPresenceRequired) {
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        AssertUtil.notNull(authenticator, "authenticator must not be null");
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
        this.allowCredentials = CollectionUtil.unmodifiableList(allowCredentials);
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    @Deprecated
    public CoreAuthenticationParameters(@NotNull CoreServerProperty serverProperty, @NotNull CoreAuthenticator authenticator, @Nullable List<byte[]> allowCredentials, boolean userVerificationRequired) {
        this(serverProperty, authenticator, allowCredentials, userVerificationRequired, true);
    }

    @Deprecated
    public CoreAuthenticationParameters(@NotNull CoreServerProperty serverProperty, @NotNull CoreAuthenticator authenticator, boolean userVerificationRequired, boolean userPresenceRequired) {
        this(serverProperty, authenticator, null, userVerificationRequired, userPresenceRequired);
    }

    @Deprecated
    public CoreAuthenticationParameters(@NotNull CoreServerProperty serverProperty, @NotNull CoreAuthenticator authenticator, boolean userVerificationRequired) {
        this(serverProperty, authenticator, null, userVerificationRequired, true);
    }

    @NotNull
    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    @NotNull
    public CoreAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public List<byte[]> getAllowCredentials() {
        return this.allowCredentials;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationParameters that = (CoreAuthenticationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.allowCredentials, that.allowCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.authenticator, this.allowCredentials, this.userVerificationRequired, this.userPresenceRequired);
    }

    public String toString() {
        return "CoreAuthenticationParameters(serverProperty=" + String.valueOf(this.serverProperty) + ", authenticator=" + String.valueOf(this.authenticator) + ", allowCredentials=" + String.valueOf(this.allowCredentials) + ", userVerificationRequired=" + this.userVerificationRequired + ", userPresenceRequired=" + this.userPresenceRequired + ")";
    }
}

