/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmMetadata;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.util.Iterators;

public abstract class JVMClassNode<T extends JVMClassNode<T, D>, D extends Difference>
extends Proto
implements Node<T, D> {
    private final JvmNodeReferenceID myId;
    private final String outFilePath;
    private final Iterable<Usage> myUsages;
    private final Iterable<JvmMetadata<?, ?>> myMetadata;

    public JVMClassNode(JVMFlags flags, String signature, String name, String outFilePath, @NotNull Iterable<ElementAnnotation> annotations, @NotNull Iterable<Usage> usages, @NotNull Iterable<JvmMetadata<?, ?>> metadata) {
        if (annotations == null) {
            JVMClassNode.$$$reportNull$$$0(0);
        }
        if (usages == null) {
            JVMClassNode.$$$reportNull$$$0(1);
        }
        if (metadata == null) {
            JVMClassNode.$$$reportNull$$$0(2);
        }
        super(flags, signature, name, annotations);
        this.myId = new JvmNodeReferenceID(name);
        this.outFilePath = outFilePath;
        this.myUsages = usages;
        this.myMetadata = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JVMClassNode(GraphDataInput in) throws IOException {
        super(in);
        this.myId = new JvmNodeReferenceID(this.getName());
        this.outFilePath = in.readUTF();
        ArrayList<Usage> usages = new ArrayList<Usage>();
        try {
            int groupCount = in.readInt();
            while (groupCount-- > 0) {
                in.readGraphElementCollection(usages);
            }
        }
        finally {
            this.myUsages = usages;
        }
        this.myMetadata = RW.readCollection(in, in::readGraphElement, new ArrayList());
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.outFilePath);
        HashMap<Class, List> usageGroups = new HashMap<Class, List>();
        for (Usage usage : this.myUsages) {
            usageGroups.computeIfAbsent(usage.getClass(), k -> new ArrayList()).add(usage);
        }
        out.writeInt(usageGroups.size());
        for (Map.Entry entry : usageGroups.entrySet()) {
            out.writeGraphElementCollection((Class)entry.getKey(), (Iterable)entry.getValue());
        }
        RW.writeCollection(out, this.myMetadata, out::writeGraphElement);
    }

    @Override
    @NotNull
    public JvmNodeReferenceID getReferenceID() {
        JvmNodeReferenceID jvmNodeReferenceID = this.myId;
        if (jvmNodeReferenceID == null) {
            JVMClassNode.$$$reportNull$$$0(3);
        }
        return jvmNodeReferenceID;
    }

    public String getOutFilePath() {
        return this.outFilePath;
    }

    @Override
    public Iterable<Usage> getUsages() {
        return this.myUsages;
    }

    public Iterable<JvmMetadata<?, ?>> getMetadata() {
        return this.myMetadata;
    }

    public <MT extends JvmMetadata<MT, ?>> Iterable<MT> getMetadata(Class<MT> metaClass) {
        return Iterators.filter((Iterable)Iterators.map(this.myMetadata, m -> metaClass.isInstance(m) ? (JvmMetadata)metaClass.cast(m) : null), Objects::nonNull);
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        if (!(other instanceof JVMClassNode)) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        JVMClassNode that = (JVMClassNode)other;
        return this.myId.equals(that.myId) && this.outFilePath.equals(that.outFilePath);
    }

    @Override
    public int diffHashCode() {
        return 31 * this.outFilePath.hashCode() + this.myId.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/JVMClassNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/JVMClassNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Diff
    extends Proto.Diff<T> {
        private final Map<Class<? extends JvmMetadata<?, ?>>, Difference.Specifier<?, ?>> myMetadataDiffCache;
        private final Supplier<Difference.Specifier<Usage, ?>> myUsagesDiff;
        final /* synthetic */ JVMClassNode this$0;

        public Diff(T past) {
            this.this$0 = this$0;
            super((Proto)this$0, past);
            this.myMetadataDiffCache = new HashMap();
            this.myUsagesDiff = Utils.lazyValue(() -> Difference.diff(((JVMClassNode)this.myPast).getUsages(), this.this$0.getUsages()));
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && this.usages().unchanged() && !this.metadataChanged();
        }

        public Difference.Specifier<Usage, ?> usages() {
            return this.myUsagesDiff.get();
        }

        public boolean metadataChanged() {
            return Iterators.find((Iterable)Iterators.unique((Iterable)Iterators.map((Iterable)Iterators.flat(((JVMClassNode)this.myPast).getMetadata(), this.this$0.getMetadata()), m -> m.getClass())), metaClass -> !this.metadata((Class)metaClass).unchanged()) != null;
        }

        public <MT extends JvmMetadata<MT, MD>, MD extends Difference> Difference.Specifier<MT, MD> metadata(Class<MT> metaClass) {
            return this.myMetadataDiffCache.computeIfAbsent(metaClass, k -> Difference.deepDiff(((JVMClassNode)this.myPast).getMetadata(metaClass), this.this$0.getMetadata(metaClass)));
        }
    }
}

