/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class RemoveUnusedGrParameterFix
implements IntentionAction {
    private final String myName;

    public RemoveUnusedGrParameterFix(GrParameter parameter) {
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("remove.parameter.0", this.myName);
        if (string == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("remove.unused.parameter", new Object[0]);
        if (string == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        PsiElement at;
        GrParameter parameter;
        if (project == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(2);
        }
        return (parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)(at = psiFile.findElementAt(editor.getCaretModel().getOffset())), GrParameter.class)) != null && this.myName.equals(parameter.getName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        GrParameter parameter;
        if (project == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(3);
        }
        if ((parameter = RemoveUnusedGrParameterFix.getParameter(editor, psiFile)) == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(parameter.getContainingFile())) {
            return;
        }
        GrMethod method = (GrMethod)parameter.getDeclarationScope();
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(parameter.getProject(), RemoveUnusedGrParameterFix.createChangeInfo(method, parameter));
        processor.run();
    }

    @Nullable
    private static GrParameter getParameter(Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        GrParameter parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)at, GrParameter.class);
        if (parameter == null) {
            return null;
        }
        return parameter;
    }

    private static GrChangeInfoImpl createChangeInfo(GrMethod method, GrParameter parameter) {
        ArrayList<GrParameterInfo> params = new ArrayList<GrParameterInfo>();
        int i2 = 0;
        for (GrParameter p : method.getParameterList().getParameters()) {
            if (p != parameter) {
                params.add(new GrParameterInfo(p, i2));
            }
            ++i2;
        }
        GrTypeElement typeElement = method.getReturnTypeElementGroovy();
        CanonicalTypes.Type wrapper = typeElement != null ? CanonicalTypes.createTypeWrapper((PsiType)method.getReturnType()) : null;
        return new GrChangeInfoImpl(method, null, wrapper, method.getName(), params, null, false);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        GrParameter parameter;
        if (project == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(6);
        }
        if ((parameter = RemoveUnusedGrParameterFix.getParameter(editor, psiFile)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                RemoveUnusedGrParameterFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }
        parameter.delete();
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(8);
        }
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

