/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GitConflict {
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final Status myOurStatus;
    @NotNull
    private final Status myTheirStatus;

    public GitConflict(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Status ourStatus, @NotNull Status theirStatus) {
        if (root == null) {
            GitConflict.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            GitConflict.$$$reportNull$$$0(1);
        }
        if (ourStatus == null) {
            GitConflict.$$$reportNull$$$0(2);
        }
        if (theirStatus == null) {
            GitConflict.$$$reportNull$$$0(3);
        }
        this.myRoot = root;
        this.myFilePath = filePath;
        this.myOurStatus = ourStatus;
        this.myTheirStatus = theirStatus;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            GitConflict.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            GitConflict.$$$reportNull$$$0(5);
        }
        return filePath;
    }

    @NotNull
    public Status getStatus(@NotNull ConflictSide side) {
        if (side == null) {
            GitConflict.$$$reportNull$$$0(6);
        }
        Status status = this.getStatus(side, false);
        if (status == null) {
            GitConflict.$$$reportNull$$$0(7);
        }
        return status;
    }

    @NotNull
    public Status getStatus(@NotNull ConflictSide side, boolean isReversed) {
        if (side == null) {
            GitConflict.$$$reportNull$$$0(8);
        }
        if (side == ConflictSide.OURS) {
            Status status = !isReversed ? this.myOurStatus : this.myTheirStatus;
            if (status == null) {
                GitConflict.$$$reportNull$$$0(9);
            }
            return status;
        }
        Status status = !isReversed ? this.myTheirStatus : this.myOurStatus;
        if (status == null) {
            GitConflict.$$$reportNull$$$0(10);
        }
        return status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitConflict conflict = (GitConflict)o;
        return this.myRoot.equals(conflict.myRoot) && this.myFilePath.equals(conflict.myFilePath) && this.myOurStatus == conflict.myOurStatus && this.myTheirStatus == conflict.myTheirStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myRoot, this.myFilePath, this.myOurStatus, this.myTheirStatus});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ourStatus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theirStatus";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitConflict";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitConflict";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static enum Status {
        MODIFIED,
        DELETED,
        ADDED;

    }

    public static enum ConflictSide {
        OURS,
        THEIRS;

    }
}

