/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.Objects;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.idea.maven.server.embedder.ArtifactData;
import org.jetbrains.idea.maven.server.embedder.RepositoryDataList;

class ArtifactRequestData {
    private final ArtifactData artifactData;
    private final RepositoryDataList repositories;

    ArtifactRequestData(ArtifactData artifactData, RepositoryDataList repositories) {
        this.artifactData = artifactData;
        this.repositories = repositories;
    }

    ArtifactRequestData(ArtifactRequest request) {
        this(new ArtifactData(request.getArtifact()), new RepositoryDataList(request.getRepositories()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactRequestData data = (ArtifactRequestData)o;
        if (!Objects.equals(this.artifactData, data.artifactData)) {
            return false;
        }
        return Objects.equals(this.repositories, data.repositories);
    }

    public int hashCode() {
        int result = this.artifactData != null ? this.artifactData.hashCode() : 0;
        result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ArtifactRequestData{artifactData='" + this.artifactData + '\'' + '}';
    }
}

