/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.Allocator;

private import glib.ConstructionException;
private import glib.Str;
private import glib.c.functions;
public  import glib.c.types;


/** */
public class Allocator
{
	/** the main Gtk struct */
	protected GAllocator* gAllocator;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GAllocator* getAllocatorStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gAllocator;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gAllocator;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GAllocator* gAllocator, bool ownedRef = false)
	{
		this.gAllocator = gAllocator;
		this.ownedRef = ownedRef;
	}

	~this ()
	{
		if ( ownedRef )
			g_allocator_free(gAllocator);
	}


	/** */
	public void free()
	{
		g_allocator_free(gAllocator);
		ownedRef = false;
	}

	/** */
	public this(string name, uint nPreallocs)
	{
		auto __p = g_allocator_new(Str.toStringz(name), nPreallocs);

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(GAllocator*) __p);
	}
}
