# frozen_string_literal: true

class CreateVulnerabilitySeverityOverrides < Gitlab::Database::Migration[2.2]
  milestone '17.9'

  # rubocop:disable Migration/EnsureFactoryForTable -- False positive
  def up
    create_table :vulnerability_severity_overrides do |t|
      t.references :vulnerability, index: true, null: false, foreign_key: { on_delete: :cascade }
      t.references :author, index: true
      t.timestamps_with_timezone null: false
      t.bigint :project_id, index: true, null: false
      t.column :original_severity, :smallint, null: false
      t.column :new_severity, :smallint, null: false
    end
  end
  # rubocop:enable Migration/EnsureFactoryForTable

  def down
    drop_table :vulnerability_severity_overrides
  end
end
