---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Twitch OAuth client secret'
---

## Description

The response body contains content that matches the pattern of a Twitch OAuth client secret was identified. OAuth client secrets are used to allow the service to execute functionality on behalf of Twitch users. A malicious actor with access to this client secret can impersonate the service and execute functionality on behalf its users.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate the OAuth client secret:

- Sign in to your Twitch account and access <https://dev.twitch.tv/console>
- Find the extension that uses the identified key
- Select "Manage" next to extension name in the "Extensions" section
- In the upper-right corner, select "Extension Settings"
- In the "Twitch API Client Configuration" section, select "Generate Secret" under "Twitch API Client Secret"
- When prompted, select "OK" from the dialog

For more information, please see [Twitch's developer documentation on OAuth](https://dev.twitch.tv/docs/authentication/getting-tokens-oauth/#authorization-code-grant-flow).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.118 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
