/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.BaseProfiledColor;
import io.sf.carte.doc.style.css.property.ColorSpaceHelper;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.DOMException;

class ColorFunction
extends ColorValue {
    private static final long serialVersionUID = 1L;
    private BaseColor color;

    ColorFunction() {
    }

    ColorFunction(BaseColor color) {
        this.color = color;
    }

    ColorFunction(ColorFunction copied) {
        super(copied);
        this.color = copied.color.clone();
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        ColorValue setfrom = (ColorValue)value;
        this.color.set((BaseColor)setfrom.getColor());
    }

    @Override
    public String getCssText() {
        return this.color.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return this.color.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        int len = this.color.getLength();
        wri.write((CharSequence)"color(");
        wri.write((CharSequence)this.color.getColorSpace());
        for (int i = 1; i < len; ++i) {
            wri.write(' ');
            this.color.item(i).writeCssText(wri);
        }
        if (this.color.isNonOpaque()) {
            wri.write((CharSequence)" / ");
            this.color.appendAlphaChannel(wri);
        }
        wri.write(')');
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.color.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.color.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        if (!this.color.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        switch (this.color.getSpace()) {
            case sRGB: {
                return (RGBColor)this.color;
            }
            case CIE_XYZ: 
            case CIE_XYZ_D50: {
                return ((XYZColorImpl)this.color).toSRGBColor(clamp);
            }
        }
        if (this.getColorModel() == CSSColorValue.ColorModel.RGB) {
            return ((ProfiledRGBColor)this.color).toSRGBColor(clamp);
        }
        throw new DOMException(9, "Custom color profile is not supported.");
    }

    @Override
    public CSSColor getColor() {
        return this.color;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.color.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue otherColor) {
        LABColor lab;
        if (!this.color.hasConvertibleComponents() || !((ColorValue)otherColor).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (otherColor.getColorModel()) {
            case LAB: {
                lab = (LABColor)otherColor.getColor();
                break;
            }
            case LCH: {
                lab = otherColor.toLABColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)otherColor.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rgbcolor.toLABColor(labColor);
                lab = labColor;
                break;
            }
            case XYZ: {
                XYZColorImpl xyz = (XYZColorImpl)otherColor.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xyz.toLABColor(labColor);
                lab = labColor;
                break;
            }
            default: {
                RGBAColor rgb = otherColor.toRGBColor(false);
                CSSColorValue rgbValue = rgb.packInValue();
                lab = rgbValue.toLABColorValue().getColor();
            }
        }
        LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
        switch (this.color.getColorModel()) {
            case RGB: {
                ((ProfiledRGBColor)this.color).toLABColor(labColor);
                break;
            }
            case XYZ: {
                ((XYZColorImpl)this.color).toLABColor(labColor);
                break;
            }
            default: {
                throw new DOMException(9, "Color space is not supported.");
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)((Object)labColor.getLightness())).getFloatValue((short)0), ((CSSTypedValue)((Object)labColor.getA())).getFloatValue((short)0), ((CSSTypedValue)((Object)labColor.getB())).getFloatValue((short)0), ((CSSTypedValue)lab.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab.getA()).getFloatValue((short)0), ((CSSTypedValue)lab.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private static void checkComponentValidity(PrimitiveValue primi, LexicalUnit lunit) throws DOMException {
        if (!(ColorFunction.isComponentUnit(primi.getUnitType()) || primi.getCssValueType() == CSSValue.CssType.TYPED && (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION || primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || primi.getPrimitiveType() == CSSValue.Type.FUNCTION || primi.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)primi).getStringValue())))) {
            throw new DOMException(17, "Type not compatible with a color component: " + (lunit != null ? lunit.getCssText() : primi.getCssText()));
        }
    }

    private static boolean isComponentUnit(short unit) {
        return unit == 0 || unit == 2;
    }

    private void setComponents(List<PrimitiveValue> components) {
        int i;
        int maxlen = this.color.getLength() - 1;
        int len = components.size();
        for (i = 0; i < len; ++i) {
            PrimitiveValue comp = components.get(i);
            comp = ColorFunction.enforceColorComponentType(comp);
            this.color.setComponent(i + 1, comp);
        }
        for (i = len; i < maxlen; ++i) {
            NumberValue zero = NumberValue.createCSSNumberValue((short)0, 0.0f);
            zero.setSubproperty(true);
            this.color.setComponent(i + 1, zero);
        }
    }

    static PrimitiveValue enforceColorComponentType(PrimitiveValue primi) throws DOMException {
        if (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            PercentageEvaluator eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)primi)));
            ColorFunction.setMaximumPrecision(primi);
        } else if (primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            PercentageEvaluator eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)primi)));
            ColorFunction.setMaximumPrecision(primi);
        }
        ColorFunction.checkComponentValidity(primi, null);
        return primi;
    }

    private static void setMaximumPrecision(PrimitiveValue primi) {
        short unit = primi.getUnitType();
        if (unit == 0) {
            ((NumberValue)primi).setMaximumFractionDigits(6);
        } else if (unit == 2) {
            ((NumberValue)primi).setMaximumFractionDigits(3);
        }
    }

    @Override
    public LABColorValue toLABColorValue() {
        LABColorValue labColor = new LABColorValue();
        LABColorImpl lab = (LABColorImpl)labColor.getColor();
        switch (this.color.getColorModel()) {
            case RGB: {
                ((ProfiledRGBColor)this.color).toLABColor(lab);
                break;
            }
            case XYZ: {
                ((XYZColorImpl)this.color).toLABColor(lab);
                break;
            }
            default: {
                throw new DOMException(9, "Custom profiles are not suported.");
            }
        }
        return labColor;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.color);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorFunction other = (ColorFunction)obj;
        return Objects.equals(this.color, other.color);
    }

    @Override
    public ColorFunction clone() {
        return new ColorFunction(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(ColorFunction.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.COLOR_FUNCTION) {
                    throw new IllegalStateException("No color() value: " + lunit.toString());
                }
                this.setLexical(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                DOMException ex = new DOMException(12, "Wrong value: " + lunit.toString());
                ex.initCause(e);
                throw ex;
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setLexical(LexicalUnit lunit) throws DOMException {
            PrimitiveValue alpha;
            String colorSpace;
            ArrayList<PrimitiveValue> components;
            block6: {
                LexicalUnit lu = lunit.getParameters();
                ValueFactory factory = new ValueFactory();
                components = new ArrayList<PrimitiveValue>(5);
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                    this.checkProxyValue(lu);
                    throw new DOMException(17, "Color space must be identifier: " + lunit.toString());
                }
                colorSpace = lu.getStringValue();
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    throw new DOMException(12, "Wrong value: " + lunit.toString());
                }
                alpha = null;
                do {
                    PrimitiveValue primi = factory.createCSSPrimitiveValue(lu, true);
                    ColorFunction.checkComponentValidity(primi, lunit);
                    components.add(primi);
                    lu = lu.getNextLexicalUnit();
                    if (lu == null) break block6;
                } while (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH);
                lu = lu.getNextLexicalUnit();
                alpha = factory.createCSSPrimitiveValue(lu, true);
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    throw new DOMException(12, "Wrong value: " + lunit.toString());
                }
            }
            ColorFunction.this.color = ColorSpaceHelper.createProfiledColor(colorSpace);
            if (ColorFunction.this.color == null) {
                if (!colorSpace.startsWith("--")) throw new DOMException(9, "Unsupported color space: " + colorSpace);
                PrimitiveValue[] ca = components.toArray(new PrimitiveValue[0]);
                ColorFunction.this.color = new BaseProfiledColor(colorSpace, ca);
            } else {
                ColorFunction.this.setComponents(components);
            }
            if (alpha == null) return;
            ColorFunction.this.color.setAlpha(alpha);
        }
    }
}

