/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AnimatedAttributeListener;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import java.util.LinkedList;
import org.w3c.dom.Element;

public abstract class AbstractSVGAnimatedValue
implements AnimatedLiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean hasAnimVal;
    protected LinkedList<AnimatedAttributeListener> listeners = new LinkedList();

    public AbstractSVGAnimatedValue(AbstractElement elt, String ns, String ln) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public boolean isSpecified() {
        return this.hasAnimVal || this.element.hasAttributeNS(this.namespaceURI, this.localName);
    }

    protected abstract void updateAnimatedValue(AnimatableValue var1);

    @Override
    public void addAnimatedAttributeListener(AnimatedAttributeListener aal) {
        if (!this.listeners.contains(aal)) {
            this.listeners.add(aal);
        }
    }

    @Override
    public void removeAnimatedAttributeListener(AnimatedAttributeListener aal) {
        this.listeners.remove(aal);
    }

    protected void fireBaseAttributeListeners() {
        if (this.element instanceof SVGOMElement) {
            ((SVGOMElement)this.element).fireBaseAttributeListeners(this.namespaceURI, this.localName);
        }
    }

    protected void fireAnimatedAttributeListeners() {
        for (AnimatedAttributeListener listener : this.listeners) {
            listener.animatedAttributeChanged((Element)((Object)this.element), this);
        }
    }
}

