/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.Property;

public class InheritedPropFunction
extends FunctionBase {
    @Override
    public int getRequiredArgsCount() {
        return 0;
    }

    @Override
    public int getOptionalArgsCount() {
        return 1;
    }

    @Override
    public Property getOptionalArgDefault(int index, PropertyInfo pi) throws PropertyException {
        if (index == 0) {
            return this.getPropertyName(pi);
        }
        return super.getOptionalArgDefault(index, pi);
    }

    @Override
    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        String propName = args[0].getString();
        if (propName == null) {
            throw new PropertyException("Incorrect parameter to inherited-property-value function");
        }
        int propId = FOPropertyMapping.getPropertyId(propName);
        if (propId < 0) {
            throw new PropertyException("Unknown property name used with inherited-property-value function: " + propName);
        }
        return pInfo.getPropertyList().getInherited(propId);
    }
}

