﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>

namespace Aws {
namespace EC2 {
namespace Model {
enum class SecondaryNetworkCidrBlockAssociationState {
  NOT_SET,
  associating,
  associated,
  association_failed,
  disassociating,
  disassociated,
  disassociation_failed
};

namespace SecondaryNetworkCidrBlockAssociationStateMapper {
AWS_EC2_API SecondaryNetworkCidrBlockAssociationState GetSecondaryNetworkCidrBlockAssociationStateForName(const Aws::String& name);

AWS_EC2_API Aws::String GetNameForSecondaryNetworkCidrBlockAssociationState(SecondaryNetworkCidrBlockAssociationState value);
}  // namespace SecondaryNetworkCidrBlockAssociationStateMapper
}  // namespace Model
}  // namespace EC2
}  // namespace Aws
