﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/AttachmentStatus.h>
#include <aws/pinpoint-sms-voice-v2/model/Tag.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class CreateRegistrationAttachmentResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API CreateRegistrationAttachmentResult() = default;
  AWS_PINPOINTSMSVOICEV2_API CreateRegistrationAttachmentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API CreateRegistrationAttachmentResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the registration attachment.</p>
   */
  inline const Aws::String& GetRegistrationAttachmentArn() const { return m_registrationAttachmentArn; }
  template <typename RegistrationAttachmentArnT = Aws::String>
  void SetRegistrationAttachmentArn(RegistrationAttachmentArnT&& value) {
    m_registrationAttachmentArnHasBeenSet = true;
    m_registrationAttachmentArn = std::forward<RegistrationAttachmentArnT>(value);
  }
  template <typename RegistrationAttachmentArnT = Aws::String>
  CreateRegistrationAttachmentResult& WithRegistrationAttachmentArn(RegistrationAttachmentArnT&& value) {
    SetRegistrationAttachmentArn(std::forward<RegistrationAttachmentArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the registration attachment.</p>
   */
  inline const Aws::String& GetRegistrationAttachmentId() const { return m_registrationAttachmentId; }
  template <typename RegistrationAttachmentIdT = Aws::String>
  void SetRegistrationAttachmentId(RegistrationAttachmentIdT&& value) {
    m_registrationAttachmentIdHasBeenSet = true;
    m_registrationAttachmentId = std::forward<RegistrationAttachmentIdT>(value);
  }
  template <typename RegistrationAttachmentIdT = Aws::String>
  CreateRegistrationAttachmentResult& WithRegistrationAttachmentId(RegistrationAttachmentIdT&& value) {
    SetRegistrationAttachmentId(std::forward<RegistrationAttachmentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the registration attachment. </p> <ul> <li> <p>
   * <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.</p> </li> <li>
   * <p> <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.</p> </li>
   * <li> <p> <code>UPLOAD_FAILED</code> The attachment failed to uploaded.</p> </li>
   * <li> <p> <code>DELETED</code> The attachment has been deleted..</p> </li> </ul>
   */
  inline AttachmentStatus GetAttachmentStatus() const { return m_attachmentStatus; }
  inline void SetAttachmentStatus(AttachmentStatus value) {
    m_attachmentStatusHasBeenSet = true;
    m_attachmentStatus = value;
  }
  inline CreateRegistrationAttachmentResult& WithAttachmentStatus(AttachmentStatus value) {
    SetAttachmentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of tags (key and value pairs) to associate with the registration
   * attachment.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  CreateRegistrationAttachmentResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  CreateRegistrationAttachmentResult& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the registration attachment was created, in <a
   * href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTimestamp() const { return m_createdTimestamp; }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  void SetCreatedTimestamp(CreatedTimestampT&& value) {
    m_createdTimestampHasBeenSet = true;
    m_createdTimestamp = std::forward<CreatedTimestampT>(value);
  }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  CreateRegistrationAttachmentResult& WithCreatedTimestamp(CreatedTimestampT&& value) {
    SetCreatedTimestamp(std::forward<CreatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateRegistrationAttachmentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registrationAttachmentArn;

  Aws::String m_registrationAttachmentId;

  AttachmentStatus m_attachmentStatus{AttachmentStatus::NOT_SET};

  Aws::Vector<Tag> m_tags;

  Aws::Utils::DateTime m_createdTimestamp{};

  Aws::String m_requestId;
  bool m_registrationAttachmentArnHasBeenSet = false;
  bool m_registrationAttachmentIdHasBeenSet = false;
  bool m_attachmentStatusHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_createdTimestampHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
