﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/macie2/Macie2_EXPORTS.h>
#include <aws/macie2/model/BucketMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Macie2 {
namespace Model {
class DescribeBucketsResult {
 public:
  AWS_MACIE2_API DescribeBucketsResult() = default;
  AWS_MACIE2_API DescribeBucketsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MACIE2_API DescribeBucketsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects, one for each bucket that matches the filter criteria
   * specified in the request.</p>
   */
  inline const Aws::Vector<BucketMetadata>& GetBuckets() const { return m_buckets; }
  template <typename BucketsT = Aws::Vector<BucketMetadata>>
  void SetBuckets(BucketsT&& value) {
    m_bucketsHasBeenSet = true;
    m_buckets = std::forward<BucketsT>(value);
  }
  template <typename BucketsT = Aws::Vector<BucketMetadata>>
  DescribeBucketsResult& WithBuckets(BucketsT&& value) {
    SetBuckets(std::forward<BucketsT>(value));
    return *this;
  }
  template <typename BucketsT = BucketMetadata>
  DescribeBucketsResult& AddBuckets(BucketsT&& value) {
    m_bucketsHasBeenSet = true;
    m_buckets.emplace_back(std::forward<BucketsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The string to use in a subsequent request to get the next page of results in
   * a paginated response. This value is null if there are no additional pages.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeBucketsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeBucketsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<BucketMetadata> m_buckets;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_bucketsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Macie2
}  // namespace Aws
