"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveModuleName = resolveModuleName;
function resolveModuleName(fileName, moduleName) {
    const { typescript: ts, languageServiceHost } = this;
    const compilerOptions = languageServiceHost.getCompilationSettings();
    const ext = moduleName.split('.').pop();
    const result = ts.resolveModuleName(moduleName, fileName, {
        ...compilerOptions,
        allowArbitraryExtensions: true,
    }, {
        fileExists(fileName) {
            fileName = transformFileName(fileName, ext);
            return languageServiceHost.fileExists(fileName);
        },
    });
    const resolveFileName = result.resolvedModule?.resolvedFileName;
    return {
        name: resolveFileName ? transformFileName(resolveFileName, ext) : undefined,
    };
}
function transformFileName(fileName, ext) {
    if (ext && fileName.endsWith(`.d.${ext}.ts`)) {
        return fileName.slice(0, -`.d.${ext}.ts`.length) + `.${ext}`;
    }
    return fileName;
}
//# sourceMappingURL=resolveModuleName.js.map