/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.slides.SlideBarActionEvent;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlideOperationFactory;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class TabbedHandler
implements ChangeListener,
ActionListener {
    private final ModeView modeView;
    private final Tabbed tabbed;
    private final int kind;
    private boolean ignoreChange = false;
    private static ActivationManager activationManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabbedHandler(ModeView modeView, int n, Tabbed tabbed) {
        this.modeView = modeView;
        this.kind = n;
        Class<TabbedHandler> clazz = TabbedHandler.class;
        synchronized (TabbedHandler.class) {
            if (activationManager == null) {
                activationManager = new ActivationManager();
                Toolkit.getDefaultToolkit().addAWTEventListener(activationManager, 16L);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", activationManager);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.tabbed = tabbed;
            this.tabbed.addChangeListener((ChangeListener)this);
            this.tabbed.addActionListener((ActionListener)this);
            ((Container)this.tabbed.getComponent()).setFocusCycleRoot(true);
            return;
        }
    }

    public void requestAttention(TopComponent topComponent) {
        this.tabbed.requestAttention(topComponent);
    }

    public void cancelRequestAttention(TopComponent topComponent) {
        this.tabbed.cancelRequestAttention(topComponent);
    }

    public void setAttentionHighlight(TopComponent topComponent, boolean bl) {
        this.tabbed.setAttentionHighlight(topComponent, bl);
    }

    public void makeBusy(TopComponent topComponent, boolean bl) {
        this.tabbed.makeBusy(topComponent, bl);
    }

    public Component getComponent() {
        return this.tabbed.getComponent();
    }

    public void addTopComponent(TopComponent topComponent, int n) {
        this.addTCIntoTab(topComponent, n);
    }

    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        this.ignoreChange = true;
        try {
            this.tabbed.setTopComponents(topComponentArray, topComponent);
        }
        finally {
            this.ignoreChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTCIntoTab(TopComponent topComponent, int n) {
        if (TabbedHandler.containsTC(this.tabbed, topComponent)) {
            return;
        }
        Image image = topComponent.getIcon();
        try {
            this.ignoreChange = true;
            String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent);
            if (string == null) {
                string = "";
            }
            this.tabbed.addTopComponent(string, image == null ? null : ImageUtilities.image2Icon((Image)image), topComponent, topComponent.getToolTipText());
        }
        finally {
            this.ignoreChange = false;
        }
    }

    private static boolean containsTC(Tabbed tabbed, TopComponent topComponent) {
        return tabbed.indexOf((Component)topComponent) != -1;
    }

    public void removeTopComponent(TopComponent topComponent) {
        this.removeTCFromTab(topComponent);
    }

    private void removeTCFromTab(TopComponent topComponent) {
        if (this.tabbed.indexOf((Component)topComponent) != -1) {
            try {
                this.ignoreChange = true;
                this.tabbed.removeComponent((Component)topComponent);
            }
            finally {
                this.ignoreChange = false;
            }
            topComponent.getAccessibleContext().setAccessibleParent(null);
        }
    }

    public void topComponentIconChanged(TopComponent topComponent) {
        int n = this.tabbed.indexOf((Component)topComponent);
        if (n < 0) {
            return;
        }
        Image image = topComponent.getIcon();
        if (null != image) {
            this.tabbed.setIconAt(n, ImageUtilities.image2Icon((Image)topComponent.getIcon()));
        } else {
            Logger.getLogger(TabbedHandler.class.getName()).log(Level.INFO, "TopComponent has no icon: " + topComponent);
            this.tabbed.setIconAt(n, null);
        }
    }

    public void topComponentNameChanged(TopComponent topComponent, int n) {
        int n2 = this.tabbed.indexOf((Component)topComponent);
        if (n2 < 0) {
            return;
        }
        String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent);
        if (string == null) {
            string = "";
        }
        this.tabbed.setTitleAt(n2, string);
    }

    public void topComponentToolTipChanged(TopComponent topComponent) {
        int n = this.tabbed.indexOf((Component)topComponent);
        if (n < 0) {
            return;
        }
        this.tabbed.setToolTipTextAt(n, topComponent.getToolTipText());
    }

    public void setSelectedTopComponent(TopComponent topComponent) {
        if (topComponent == this.getSelectedTopComponent()) {
            return;
        }
        if (topComponent == null && !this.isNullSelectionAllowed()) {
            return;
        }
        if (this.tabbed.indexOf((Component)topComponent) >= 0 || this.isNullSelectionAllowed() && topComponent == null) {
            try {
                this.ignoreChange = true;
                this.tabbed.setSelectedComponent((Component)topComponent);
            }
            finally {
                this.ignoreChange = false;
            }
        }
    }

    private boolean isNullSelectionAllowed() {
        return this.kind == 2;
    }

    public TopComponent getSelectedTopComponent() {
        return this.tabbed.getSelectedTopComponent();
    }

    public TopComponent[] getTopComponents() {
        return this.tabbed.getTopComponents();
    }

    public void setActive(boolean bl) {
        this.tabbed.setActive(bl);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.ignoreChange || changeEvent.getSource() != this.tabbed) {
            return;
        }
        TopComponent topComponent = this.tabbed.getSelectedTopComponent();
        this.modeView.getController().userSelectedTab(this.modeView, topComponent);
    }

    public Shape getIndicationForLocation(Point point, TopComponent topComponent, Point point2, boolean bl) {
        return this.tabbed.getIndicationForLocation(point, topComponent, point2, bl);
    }

    public Object getConstraintForLocation(Point point, boolean bl) {
        return this.tabbed.getConstraintForLocation(point, bl);
    }

    public Rectangle getTabBounds(int n) {
        return this.tabbed.getTabBounds(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent instanceof TabActionEvent) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            String string = tabActionEvent.getActionCommand();
            if ("select".equals(string)) {
                return;
            }
            tabActionEvent.consume();
            if ("close" == string) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
                if (topComponent != null && this.modeView != null) {
                    this.modeView.getController().userClosedTopComponent(this.modeView, topComponent);
                } else {
                    Logger.getLogger(TabbedHandler.class.getName()).warning("TopComponent to be closed is null at index " + tabActionEvent.getTabIndex());
                }
            } else if ("popup" == string) {
                TabbedHandler.handlePopupMenuShowing(tabActionEvent.getMouseEvent(), tabActionEvent.getTabIndex());
            } else if ("maximize" == string) {
                TabbedHandler.handleMaximization(tabActionEvent);
            } else if ("closeAll" == string) {
                ActionUtils.closeAllDocuments(true);
            } else if ("closeAllButThis" == string) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
                ActionUtils.closeAllExcept(topComponent, true);
            } else if ("enableAutoHide".equals(string)) {
                if (Switches.isTopComponentSlidingEnabled() && this.tabbed.getComponent().isShowing()) {
                    TopComponent topComponent = this.tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
                    Component component = this.tabbed.getComponent();
                    String string2 = WindowManagerImpl.getInstance().guessSlideSide(topComponent);
                    SlideOperation slideOperation = SlideOperationFactory.createSlideIntoEdge(component, string2, true);
                    slideOperation.setStartBounds(new Rectangle(component.getLocationOnScreen(), component.getSize()));
                    slideOperation.prepareEffect();
                    this.modeView.getController().userEnabledAutoHide(this.modeView, topComponent);
                    this.modeView.getController().userTriggeredSlideIntoEdge(this.modeView, slideOperation);
                }
            } else if ("minimizeGroup".equals(string)) {
                if (Switches.isModeSlidingEnabled()) {
                    TopComponent topComponent = this.tabbed.getTopComponentAt(0);
                    WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
                    ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
                    if (null != modeImpl) {
                        windowManagerImpl.userMinimizedMode(modeImpl);
                    }
                }
            } else if ("restoreGroup".equals(string)) {
                String string3 = tabActionEvent.getGroupName();
                if (null != string3) {
                    TopComponent topComponent = this.tabbed.getTopComponentAt(0);
                    WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
                    ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
                    ModeImpl modeImpl2 = (ModeImpl)windowManagerImpl.findMode(string3);
                    if (null != modeImpl2 && null != modeImpl) {
                        windowManagerImpl.userRestoredMode(modeImpl, modeImpl2);
                    }
                }
            } else if ("closeGroup".equals(string) && Switches.isModeClosingEnabled()) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(0);
                WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
                ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
                if (null != modeImpl) {
                    windowManagerImpl.userClosedMode(modeImpl);
                }
            }
        } else if (actionEvent instanceof SlideBarActionEvent) {
            TopComponent topComponent;
            MaximizeWindowAction maximizeWindowAction;
            SlideBarActionEvent slideBarActionEvent = (SlideBarActionEvent)actionEvent;
            String string = slideBarActionEvent.getActionCommand();
            if ("popup".equals(string)) {
                TabbedHandler.handlePopupMenuShowing(slideBarActionEvent.getMouseEvent(), slideBarActionEvent.getTabIndex());
            } else if ("slideIn".equals(string)) {
                this.modeView.getController().userTriggeredSlideIn(this.modeView, slideBarActionEvent.getSlideOperation());
            } else if ("slideResize".equals(string)) {
                this.modeView.getController().userResizedSlidingWindow(this.modeView, slideBarActionEvent.getSlideOperation());
            } else if ("slideOut".equals(string)) {
                ProxySlideOperation proxySlideOperation = new ProxySlideOperation(slideBarActionEvent.getSlideOperation(), this.ignoreChange);
                this.modeView.getController().userTriggeredSlideOut(this.modeView, proxySlideOperation);
            } else if ("disableAutoHide".equals(string)) {
                TopComponent topComponent2 = this.tabbed.getTopComponentAt(slideBarActionEvent.getTabIndex());
                this.modeView.getController().userDisabledAutoHide(this.modeView, topComponent2);
            } else if ("slideMaximize" == string && (maximizeWindowAction = new MaximizeWindowAction(topComponent = this.tabbed.getTopComponentAt(slideBarActionEvent.getTabIndex()))).isEnabled()) {
                maximizeWindowAction.actionPerformed(actionEvent);
            }
        }
    }

    public static void handlePopupMenuShowing(MouseEvent mouseEvent, int n) {
        TopComponent topComponent;
        Component component;
        for (component = (Component)mouseEvent.getSource(); component != null && !(component instanceof Tabbed.Accessor); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        Tabbed tabbed = ((Tabbed.Accessor)component).getTabbed();
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
        int n2 = n;
        Lookup lookup = null;
        Action[] actionArray = null;
        if (n2 >= 0 && (topComponent = tabbed.getTopComponentAt(n2)) != null) {
            actionArray = tabbed.getPopupActions(topComponent.getActions(), n2);
            if (actionArray == null) {
                actionArray = topComponent.getActions();
            }
            if (actionArray == null || actionArray.length == 0) {
                return;
            }
            lookup = topComponent.getLookup();
        }
        if (null == lookup) {
            actionArray = tabbed.getPopupActions(new Action[0], -1);
            if (actionArray == null || actionArray.length == 0) {
                return;
            }
            lookup = Lookup.getDefault();
        }
        TabbedHandler.showPopupMenu(Utilities.actionsToPopup(actionArray, lookup), point, component);
    }

    private static void showPopupMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        jPopupMenu.show(component, point.x, point.y);
    }

    public static void handleMaximization(TabActionEvent tabActionEvent) {
        Component component;
        for (component = (Component)tabActionEvent.getSource(); component != null && !(component instanceof Tabbed.Accessor); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        Tabbed tabbed = ((Tabbed.Accessor)component).getTabbed();
        TopComponent topComponent = tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
        MaximizeWindowAction maximizeWindowAction = new MaximizeWindowAction(topComponent);
        if (maximizeWindowAction.isEnabled()) {
            maximizeWindowAction.actionPerformed((ActionEvent)tabActionEvent);
        }
    }

    private static class ProxySlideOperation
    implements SlideOperation {
        private SlideOperation original;
        private boolean disable;

        public ProxySlideOperation(SlideOperation slideOperation, boolean bl) {
            this.original = slideOperation;
            this.disable = bl;
        }

        @Override
        public Component getComponent() {
            return this.original.getComponent();
        }

        @Override
        public Rectangle getFinishBounds() {
            return this.original.getFinishBounds();
        }

        @Override
        public String getSide() {
            return this.original.getSide();
        }

        @Override
        public Rectangle getStartBounds() {
            return this.original.getStartBounds();
        }

        @Override
        public int getType() {
            return this.original.getType();
        }

        @Override
        public void prepareEffect() {
            this.original.prepareEffect();
        }

        @Override
        public boolean requestsActivation() {
            if (this.disable) {
                return false;
            }
            return this.original.requestsActivation();
        }

        @Override
        public void run(JLayeredPane jLayeredPane, Integer n) {
            this.original.run(jLayeredPane, n);
        }

        @Override
        public void setFinishBounds(Rectangle rectangle) {
            this.original.setFinishBounds(rectangle);
        }

        @Override
        public void setStartBounds(Rectangle rectangle) {
            this.original.setStartBounds(rectangle);
        }
    }

    private static class ActivationManager
    implements AWTEventListener,
    PropertyChangeListener {
        private ActivationManager() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 501) {
                this.handleActivation(aWTEvent.getSource());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Frame frame = WindowManagerImpl.getInstance().getMainWindow();
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (frame == window && frame != SwingUtilities.getRoot((Component)topComponent)) {
                this.handleActivation(propertyChangeEvent.getNewValue());
            }
        }

        private void handleActivation(Object object) {
            Object object2;
            Component component;
            if (!(object instanceof Component)) {
                return;
            }
            for (component = (Component)object; component != null && !(component instanceof ModeComponent); component = component.getParent()) {
                if (component instanceof JComponent && Boolean.TRUE.equals(((JComponent)(object2 = (JComponent)component)).getClientProperty("dontActivate"))) {
                    return;
                }
                if (!(component instanceof TopComponent) || !Boolean.TRUE.equals((object2 = (TopComponent)component).getClientProperty((Object)"isSliding"))) continue;
                object2.requestActive();
                return;
            }
            if (component instanceof ModeComponent && (object2 = (ModeComponent)((Object)component)).getKind() != 2) {
                ModeView modeView = object2.getModeView();
                modeView.getController().userActivatedModeView(modeView);
            }
        }
    }
}

