/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.sampler.CPUSamplerViewSupport;
import org.graalvm.visualvm.jfr.views.sampler.MemorySamplerViewSupport;
import org.graalvm.visualvm.jfr.views.sampler.SamplerViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class JFRSnapshotSamplerView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/sampler.png";
    private DataViewComponent dvc;
    private SamplerViewSupport.MasterViewSupport masterView;
    private DataViewComponent.DetailsView[] currentDetails;

    JFRSnapshotSamplerView(JFRSnapshot jfrSnapshot) {
        super(jfrSnapshot, NbBundle.getMessage(JFRSnapshotSamplerView.class, (String)"LBL_Sampler"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 70);
    }

    @Override
    protected DataViewComponent createComponent() {
        final JFRModel model = this.getModel();
        this.masterView = new SamplerViewSupport.MasterViewSupport(model){

            @Override
            void showCPU() {
                JFRSnapshotSamplerView.this.showCPU(model);
            }

            @Override
            void showMemory() {
                JFRSnapshotSamplerView.this.showMemory(model);
            }
        };
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(model == null));
        if (model != null) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotSamplerView.class, (String)"LBL_Summary"), false), 1);
            DataViewComponent.DetailsView summaryView = new SamplerViewSupport.SummaryViewSupport(model).getDetailsView();
            this.dvc.addDetailsView(summaryView, 1);
            this.currentDetails = new DataViewComponent.DetailsView[]{summaryView};
        }
        return this.dvc;
    }

    private void showCPU(JFRModel model) {
        for (DataViewComponent.DetailsView detail : this.currentDetails) {
            this.dvc.removeDetailsView(detail);
        }
        CPUSamplerViewSupport.CPUViewSupport cpuView = new CPUSamplerViewSupport.CPUViewSupport(model);
        DataViewComponent.DetailsView cpuViewW = cpuView.getDetailsView();
        this.dvc.addDetailsView(cpuViewW, 1);
        CPUSamplerViewSupport.ThreadsCPUViewSupport threadCpuView = new CPUSamplerViewSupport.ThreadsCPUViewSupport(model);
        DataViewComponent.DetailsView threadsCpuViewW = threadCpuView.getDetailsView();
        this.dvc.addDetailsView(threadsCpuViewW, 1);
        this.currentDetails = new DataViewComponent.DetailsView[]{cpuViewW, threadsCpuViewW};
        this.initialize(cpuView, threadCpuView);
    }

    private void showMemory(JFRModel model) {
        for (DataViewComponent.DetailsView detail : this.currentDetails) {
            this.dvc.removeDetailsView(detail);
        }
        MemorySamplerViewSupport.HeapViewSupport heapView = new MemorySamplerViewSupport.HeapViewSupport(model);
        DataViewComponent.DetailsView heapViewW = heapView.getDetailsView();
        this.dvc.addDetailsView(heapViewW, 1);
        MemorySamplerViewSupport.ThreadsMemoryViewSupport threadsMemoryView = new MemorySamplerViewSupport.ThreadsMemoryViewSupport(model);
        DataViewComponent.DetailsView threadsMemoryViewW = threadsMemoryView.getDetailsView();
        this.dvc.addDetailsView(threadsMemoryViewW, 1);
        this.currentDetails = new DataViewComponent.DetailsView[]{heapViewW, threadsMemoryViewW};
        this.initialize(heapView, threadsMemoryView);
    }

    private void initialize(final JFREventVisitor ... visitors) {
        new RequestProcessor("JFR Sampler Initializer").post(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotSamplerView.this.masterView.showProgress();
                JFRSnapshotSamplerView.this.getModel().visitEvents(visitors);
                JFRSnapshotSamplerView.this.masterView.hideProgress();
            }
        });
    }
}

