/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class AcceptLanguage {
    private final Locale locale;
    private final double quality;

    protected AcceptLanguage(Locale locale, double d) {
        this.locale = locale;
        this.quality = d;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public double getQuality() {
        return this.quality;
    }

    public static List<AcceptLanguage> parse(StringReader stringReader) throws IOException {
        ArrayList<AcceptLanguage> arrayList = new ArrayList<AcceptLanguage>();
        while (true) {
            String string;
            if ((string = HttpParser.readToken(stringReader)) == null) {
                HttpParser.skipUntil(stringReader, 0, ',');
                continue;
            }
            if (string.isEmpty()) break;
            double d = 1.0;
            SkipResult skipResult = HttpParser.skipConstant(stringReader, ";");
            if (skipResult == SkipResult.FOUND) {
                d = HttpParser.readWeight(stringReader, ',');
            }
            if (!(d > 0.0)) continue;
            arrayList.add(new AcceptLanguage(Locale.forLanguageTag(string), d));
        }
        return arrayList;
    }
}

