// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const addEmptyLineBefore = require('./addEmptyLineBefore.cjs');
const validateTypes = require('./validateTypes.cjs');
const removeEmptyLinesBefore = require('./removeEmptyLinesBefore.cjs');

/**
 * fix callback for *-empty-line-before rules
 * @param {object} o
 * @param {import('postcss').Node} o.node
 * @param {string=} o.newline
 * @param {'add'|'remove'} o.action
 * @throws {TypeError}
 */
function fixEmptyLinesBefore({ node, newline, action }) {
	validateTypes.assert(newline);

	switch (action) {
		case 'add':
			addEmptyLineBefore(node, newline);
			break;
		case 'remove':
			removeEmptyLinesBefore(node, newline);
			break;
		default:
			throw new TypeError(`Unknown action ${action}`);
	}
}

module.exports = fixEmptyLinesBefore;
