/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Put
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Put> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Item").getter(Put.getter(Put::item)).setter(Put.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(Put.getter(Put::tableName)).setter(Put.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionExpression").getter(Put.getter(Put::conditionExpression)).setter(Put.setter(Builder::conditionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeNames").getter(Put.getter(Put::expressionAttributeNames)).setter(Put.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeValues").getter(Put.getter(Put::expressionAttributeValues)).setter(Put.setter(Builder::expressionAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnValuesOnConditionCheckFailure").getter(Put.getter(Put::returnValuesOnConditionCheckFailureAsString)).setter(Put.setter(Builder::returnValuesOnConditionCheckFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValuesOnConditionCheckFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, TABLE_NAME_FIELD, CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD, RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Put.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> item;
    private final String tableName;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;
    private final String returnValuesOnConditionCheckFailure;

    private Put(BuilderImpl builder) {
        this.item = builder.item;
        this.tableName = builder.tableName;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> item() {
        return this.item;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String conditionExpression() {
        return this.conditionExpression;
    }

    public final boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public final boolean hasExpressionAttributeValues() {
        return this.expressionAttributeValues != null && !(this.expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public final ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(this.returnValuesOnConditionCheckFailure);
    }

    public final String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeValues() ? this.expressionAttributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Put)) {
            return false;
        }
        Put other = (Put)obj;
        return this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.conditionExpression(), other.conditionExpression()) && this.hasExpressionAttributeNames() == other.hasExpressionAttributeNames() && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && this.hasExpressionAttributeValues() == other.hasExpressionAttributeValues() && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues()) && Objects.equals(this.returnValuesOnConditionCheckFailureAsString(), other.returnValuesOnConditionCheckFailureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Put").add("Item", this.hasItem() ? this.item() : null).add("TableName", (Object)this.tableName()).add("ConditionExpression", (Object)this.conditionExpression()).add("ExpressionAttributeNames", this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null).add("ExpressionAttributeValues", this.hasExpressionAttributeValues() ? this.expressionAttributeValues() : null).add("ReturnValuesOnConditionCheckFailure", (Object)this.returnValuesOnConditionCheckFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ConditionExpression": {
                return Optional.ofNullable(clazz.cast(this.conditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeValues()));
            }
            case "ReturnValuesOnConditionCheckFailure": {
                return Optional.ofNullable(clazz.cast(this.returnValuesOnConditionCheckFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Item", ITEM_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("ConditionExpression", CONDITION_EXPRESSION_FIELD);
        map.put("ExpressionAttributeNames", EXPRESSION_ATTRIBUTE_NAMES_FIELD);
        map.put("ExpressionAttributeValues", EXPRESSION_ATTRIBUTE_VALUES_FIELD);
        map.put("ReturnValuesOnConditionCheckFailure", RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Put, T> g) {
        return obj -> g.apply((Put)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();
        private String tableName;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();
        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(Put model) {
            this.item(model.item);
            this.tableName(model.tableName);
            this.conditionExpression(model.conditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
            this.returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            Map<String, AttributeValue.Builder> result = PutItemInputAttributeMapCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (this.expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.expressionAttributeNames;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            Map<String, AttributeValue.Builder> result = ExpressionAttributeValueMapCopier.copyToBuilder(this.expressionAttributeValues);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return this.returnValuesOnConditionCheckFailure;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure == null ? null : returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        public Put build() {
            return new Put(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Put> {
        public Builder item(Map<String, AttributeValue> var1);

        public Builder tableName(String var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder returnValuesOnConditionCheckFailure(String var1);

        public Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure var1);
    }
}

