/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionSCNs = new LongDeque();

    public TransactionManagerMV2PL(Database database) {
        super(database);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 1;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long l) {
        this.systemChangeNumber.set(l);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 1;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        this.writeLock.lock();
        try {
            int n;
            int n2 = session.rowActionList.size();
            session.actionSCN = this.getNextSystemChangeNumber();
            for (n = 0; n < n2; ++n) {
                RowAction rowAction = (RowAction)session.rowActionList.get(n);
                rowAction.prepareCommit(session);
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] objectArray;
            int n;
            int n2 = session.rowActionList.size();
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (n = 0; n < n2; ++n) {
                objectArray = (Object[])session.rowActionList.get(n);
                objectArray.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            n = session.rowActionList.size();
            if (n > n2) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(objectArray, n2, n, session.actionSCN);
                this.finaliseRows(session, objectArray, n2, n);
                session.rowActionList.setSize(n2);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionSCN) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(objectArray, 0, n2, session.actionSCN);
                this.finaliseRows(session, objectArray, 0, n2);
            } else {
                objectArray = session.rowActionList.toArray();
                this.addToCommittedQueue(session, objectArray);
            }
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
            session.actionSet.clear();
        }
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int n, long l) {
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                rowAction.rollback(session, l);
                int n3 = rowAction.mergeRollback(session, l);
                if (rowAction.type == 3) {
                    if (rowAction.deleteComplete) continue;
                    rowAction.deleteComplete = true;
                }
                rowAction.store.rollbackRow(session, row, n3, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(n);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = persistentStore.addDeleteActionToRow(session, row, nArray, true);
        if (table.isTemp) {
            persistentStore.delete(session, row);
            row.rowAction = null;
            if (table.persistenceScope == 20) {
                return rowAction;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        persistentStore.indexRow(session, row);
        if (table.persistenceScope == 20) {
            row.rowAction = null;
            return;
        }
        session.rowActionList.add(rowAction);
    }

    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        if (rowAction.table.isTemp) {
            return true;
        }
        return rowAction.canRead(session, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionSCNs;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionSCNs.addLast(session.actionSCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long l2 = 0L;
            Object[] objectArray = null;
            LongDeque longDeque = this.committedTransactionSCNs;
            synchronized (longDeque) {
                if (this.committedTransactionSCNs.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionSCNs.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionSCNs.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length);
        }
    }

    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((statement = this.updateCurrentStatement(session, statement)) == null) {
                return;
            }
            boolean bl = this.setWaitedSessionsTPL(session, statement);
            if (bl) {
                session.isPreTransaction = true;
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            if (session.isTransaction) {
                session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
            } else {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void resetSession(Session session, Session session2, long l, int n) {
        super.resetSession(session, session2, l, n);
    }

    private void endTransaction(Session session) {
        long l = session.transactionSCN;
        int n = this.liveTransactionSCNs.indexOf(l);
        if (n >= 0) {
            this.transactionCount.decrementAndGet();
            this.liveTransactionSCNs.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }
}

