/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.hyperlink.BeansRefHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.FactoryMethodHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.JavaMethodHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.PHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.PropertyHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.ResourceHyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;

public class SpringXMLConfigHyperlinkProvider
implements HyperlinkProvider {
    private static final String P_NAMESPACE = "http://www.springframework.org/schema/p";
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();
    private PHyperlinkProcessor pHyperlinkProcessor = new PHyperlinkProcessor();

    public SpringXMLConfigHyperlinkProvider() {
        JavaClassHyperlinkProcessor classHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueProcessor("bean", "class", classHyperlinkProcessor);
        JavaMethodHyperlinkProcessor methodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(Public.DONT_CARE, Static.NO, 0);
        this.registerAttribValueProcessor("bean", "init-method", methodHyperlinkProcessor);
        this.registerAttribValueProcessor("bean", "destroy-method", methodHyperlinkProcessor);
        FactoryMethodHyperlinkProcessor factoryMethodHyperlinkProcessor = new FactoryMethodHyperlinkProcessor();
        this.registerAttribValueProcessor("bean", "factory-method", factoryMethodHyperlinkProcessor);
        methodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(Public.DONT_CARE, Static.NO, 0);
        this.registerAttribValueProcessor("lookup-method", "name", methodHyperlinkProcessor);
        methodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(Public.DONT_CARE, Static.NO, -1);
        this.registerAttribValueProcessor("replaced-method", "name", methodHyperlinkProcessor);
        ResourceHyperlinkProcessor resourceHyperlinkProcessor = new ResourceHyperlinkProcessor();
        this.registerAttribValueProcessor("import", "resource", resourceHyperlinkProcessor);
        PropertyHyperlinkProcessor propertyHyperlinkProcessor = new PropertyHyperlinkProcessor();
        this.registerAttribValueProcessor("property", "name", propertyHyperlinkProcessor);
        BeansRefHyperlinkProcessor beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(true);
        this.registerAttribValueProcessor("bean", "factory-bean", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("bean", "depends-on", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("bean", "parent", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("lookup-method", "bean", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("replaced-method", "replacer", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("property", "ref", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("alias", "name", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("constructor-arg", "ref", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("ref", "bean", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("idref", "bean", beansRefHyperlinkProcessor);
        beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(false);
        this.registerAttribValueProcessor("idref", "local", beansRefHyperlinkProcessor);
        this.registerAttribValueProcessor("ref", "local", beansRefHyperlinkProcessor);
    }

    private void registerAttribValueProcessor(String tagName, String attribName, HyperlinkProcessor processor) {
        this.attribValueProcessors.put(this.createRegisteredName(tagName, attribName), processor);
    }

    public boolean isHyperlinkPoint(Document document, int offset) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        if (XMLSyntaxSupport.getSyntaxSupport((Document)document) == null) {
            return false;
        }
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        HyperlinkProcessor processor = this.locateProcessor(env);
        return processor != null;
    }

    public int[] getHyperlinkSpan(Document document, int offset) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        HyperlinkProcessor processor = this.locateProcessor(env);
        if (processor == null) {
            return new int[]{-1, -1};
        }
        return processor.getSpan(env);
    }

    public void performClickAction(Document document, int offset) {
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        HyperlinkProcessor processor = this.locateProcessor(env);
        if (processor != null) {
            processor.process(env);
        }
    }

    private HyperlinkProcessor locateProcessor(HyperlinkEnv env) {
        HyperlinkProcessor processor = null;
        if (env.getType().isValueHyperlink()) {
            processor = this.locateAttributeValueProcessor(env.getTagName(), env.getAttribName());
            if (processor == null && this.isPNamespaceName(env, env.getAttribName())) {
                processor = this.pHyperlinkProcessor;
            }
        } else if (env.getType().isAttributeHyperlink() && this.isPNamespaceName(env, env.getAttribName())) {
            processor = this.pHyperlinkProcessor;
        }
        return processor;
    }

    protected String createRegisteredName(String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.hasText(nodeName)) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (StringUtils.hasText(attributeName)) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    private HyperlinkProcessor locateAttributeValueProcessor(String nodeName, String attributeName) {
        String key = this.createRegisteredName(nodeName, attributeName);
        if (this.attribValueProcessors.containsKey(key)) {
            return this.attribValueProcessors.get(key);
        }
        key = this.createRegisteredName("*", attributeName);
        if (this.attribValueProcessors.containsKey(key)) {
            return this.attribValueProcessors.get(key);
        }
        return null;
    }

    private boolean isPNamespaceName(HyperlinkEnv env, String nodeName) {
        String namespaceUri;
        String prefix = ContextUtilities.getPrefixFromNodeName(nodeName);
        return prefix != null && P_NAMESPACE.equals(namespaceUri = env.lookupNamespacePrefix(prefix));
    }
}

