/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.singlesourcefile;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.file.launcher.api.SourceLauncher;
import org.netbeans.modules.java.file.launcher.spi.SingleFileOptionsQueryImplementation;
import org.netbeans.modules.java.lsp.server.protocol.Workspace;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public abstract class SingleFileOptionsQueryImpl
implements SingleFileOptionsQueryImplementation {
    private final Map<Workspace, WorkspaceSettings> workspace2Settings = new WeakHashMap<Workspace, WorkspaceSettings>();
    private final Map<Workspace, Map<FileObject, ResultImpl>> workspace2Folder2Options = new WeakHashMap<Workspace, Map<FileObject, ResultImpl>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleFileOptionsQueryImplementation.Result optionsFor(FileObject file) {
        if (SingleFileOptionsQueryImpl.isSingleSourceFile(file)) {
            Set<Workspace> workspaces;
            FileObject workspaceFolder;
            Workspace workspace = (Workspace)Lookup.getDefault().lookup(Workspace.class);
            FileObject fileObject = workspaceFolder = workspace != null ? SingleFileOptionsQueryImpl.findWorkspaceFolder(workspace, file) : null;
            if (workspaceFolder != null) {
                return this.getResult(workspace, workspaceFolder);
            }
            SingleFileOptionsQueryImpl singleFileOptionsQueryImpl = this;
            synchronized (singleFileOptionsQueryImpl) {
                workspaces = this.workspace2Settings.keySet();
            }
            for (Workspace w : workspaces) {
                FileObject folder = SingleFileOptionsQueryImpl.findWorkspaceFolder(w, file);
                if (folder == null) continue;
                return this.getResult(w, folder);
            }
            return null;
        }
        return null;
    }

    private synchronized SingleFileOptionsQueryImplementation.Result getResult(Workspace workspace, FileObject workspaceFolder) {
        Map folder2Result = this.workspace2Folder2Options.computeIfAbsent(workspace, w -> new HashMap());
        return folder2Result.computeIfAbsent(workspaceFolder, f -> new ResultImpl(folder2Result, workspaceFolder, this.getWorkspaceSettings(workspace)));
    }

    static FileObject findWorkspaceFolder(Workspace workspace, FileObject file) {
        for (FileObject workspaceFolder : workspace.getClientWorkspaceFolders()) {
            if (!FileUtil.isParentOf((FileObject)workspaceFolder, (FileObject)file) && workspaceFolder != file) continue;
            return workspaceFolder;
        }
        for (FileObject workspaceFolder : workspace.getClientWorkspaceFolders()) {
            if (!FileUtil.isParentOf((FileObject)file, (FileObject)workspaceFolder)) continue;
            return workspaceFolder;
        }
        return null;
    }

    public boolean setConfiguration(Workspace workspace, String vmOptions, String workDirectory) {
        return this.getWorkspaceSettings(workspace).setOptions(vmOptions, workDirectory);
    }

    private synchronized WorkspaceSettings getWorkspaceSettings(Workspace workspace) {
        Parameters.notNull((CharSequence)"workspace", (Object)workspace);
        return this.workspace2Settings.computeIfAbsent(workspace, w -> new WorkspaceSettings());
    }

    static boolean isSingleSourceFile(FileObject fObj) {
        Project p = FileOwnerQuery.getOwner((FileObject)fObj);
        if (p != null) {
            return false;
        }
        if (!fObj.isFolder() && !fObj.getExt().equalsIgnoreCase("java")) {
            return false;
        }
        return SourceLauncher.isSourceLauncherFile((FileObject)fObj);
    }

    private final class WorkspaceSettings {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String options;
        private String workdirDirectory;

        private WorkspaceSettings() {
        }

        public synchronized String getOptions() {
            return this.options;
        }

        public synchronized String getWorkDirectory() {
            return this.workdirDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setOptions(String options, String workingDirectory) {
            boolean modified = false;
            WorkspaceSettings workspaceSettings = this;
            synchronized (workspaceSettings) {
                if (!Objects.equals(this.options, options)) {
                    this.options = options;
                    modified = true;
                }
                if (!Objects.equals(this.workdirDirectory, workingDirectory)) {
                    this.workdirDirectory = workingDirectory;
                    modified = true;
                }
            }
            if (modified) {
                this.cs.fireChange();
            }
            return modified;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }
    }

    private static final class ResultImpl
    extends FileChangeAdapter
    implements SingleFileOptionsQueryImplementation.Result,
    ChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final Map<FileObject, ResultImpl> workspaceFolders2Results;
        private final FileObject workspaceFolder;
        private final WorkspaceSettings workspaceSettings;

        public ResultImpl(Map<FileObject, ResultImpl> workspaceFolders2Results, FileObject workspaceFolder, WorkspaceSettings workspaceSettings) {
            this.workspaceFolders2Results = workspaceFolders2Results;
            this.workspaceFolder = workspaceFolder;
            this.workspaceSettings = workspaceSettings;
            workspaceSettings.addChangeListener(this);
            workspaceFolder.addFileChangeListener((FileChangeListener)this);
        }

        public String getOptions() {
            String options = this.workspaceSettings.getOptions();
            return options != null ? options : "";
        }

        public URI getWorkDirectory() {
            String cwd = this.workspaceSettings.getWorkDirectory();
            FileObject workDir = cwd != null ? FileUtil.toFileObject((File)new File(cwd)) : this.workspaceFolder;
            return workDir.toURI();
        }

        public boolean registerRoot() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.cs.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.workspaceFolders2Results.remove(this.workspaceFolder);
        }
    }
}

