/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.Bundle;
import org.netbeans.modules.maven.spi.nodes.OtherSourcesExclude;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public class J2eeMavenSourcesImpl
implements Sources,
OtherSourcesExclude {
    public static final String TYPE_DOC_ROOT = "doc_root";
    public static final String TYPE_WEB_INF = "web_inf";
    private final Project project;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl;
    private List<SourceGroup> webResourceRoots;

    public J2eeMavenSourcesImpl(Project project) {
        this.project = project;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("MavenProject".equals(event.getPropertyName()) && J2eeMavenSourcesImpl.this.hasChanged()) {
                    J2eeMavenSourcesImpl.this.cs.fireChange();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasChanged() {
        List<SourceGroup> resourceRoots = this.getWebSourceGroups();
        J2eeMavenSourcesImpl j2eeMavenSourcesImpl = this;
        synchronized (j2eeMavenSourcesImpl) {
            if (this.webResourceRoots == null || !this.webResourceRoots.equals(resourceRoots)) {
                this.webResourceRoots = resourceRoots;
                return true;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.cs.hasListeners()) {
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
        }
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
        if (!this.cs.hasListeners()) {
            NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String str) {
        if (TYPE_DOC_ROOT.equals(str)) {
            J2eeMavenSourcesImpl j2eeMavenSourcesImpl = this;
            synchronized (j2eeMavenSourcesImpl) {
                if (this.webResourceRoots == null) {
                    this.webResourceRoots = this.getWebSourceGroups();
                }
                return this.webResourceRoots.toArray(new SourceGroup[0]);
            }
        }
        return new SourceGroup[0];
    }

    private List<SourceGroup> getWebSourceGroups() {
        ArrayList<SourceGroup> sourceGroups = new ArrayList<SourceGroup>();
        ProjectWebRootProvider webRootProvider = (ProjectWebRootProvider)this.project.getLookup().lookup(ProjectWebRootProvider.class);
        if (webRootProvider != null) {
            Collection webRoots = webRootProvider.getWebRoots();
            String projectDirPath = this.project.getProjectDirectory().getPath() + "/src/main/webapp";
            for (FileObject webRoot : webRoots) {
                boolean isDefault = webRoot.getPath().equals(projectDirPath);
                WebResourceGroup g = new WebResourceGroup(this.project, webRoot, TYPE_DOC_ROOT, this.getDisplayName(webRoot, isDefault));
                if (isDefault) {
                    sourceGroups.add(0, g);
                    continue;
                }
                sourceGroups.add(g);
            }
        }
        return sourceGroups;
    }

    private String getDisplayName(FileObject webRoot, boolean isDefault) {
        if (isDefault) {
            return Bundle.LBL_WebPages();
        }
        return Bundle.LBL_WebPages() + " (" + webRoot.getPath() + ")";
    }

    public Set<Path> excludedFolders() {
        HashSet<Path> result = new HashSet<Path>();
        for (SourceGroup sourceGroup : this.getSourceGroups(TYPE_DOC_ROOT)) {
            result.add(FileUtil.toFile((FileObject)sourceGroup.getRootFolder()).toPath());
        }
        return result;
    }

    private static class WebResourceGroup
    implements SourceGroup {
        private final SourceGroup group;
        private final Project project;

        private WebResourceGroup(Project project, FileObject webRoot, String name, String displayName) {
            this.project = project;
            this.group = GenericSources.group((Project)project, (FileObject)webRoot, (String)name, (String)displayName, null, null);
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.project != null ? this.project.hashCode() : 0);
            hash = 89 * hash + (this.group.getRootFolder() != null ? this.group.getRootFolder().hashCode() : 0);
            hash = 89 * hash + (this.group.getName() != null ? this.group.getName().hashCode() : 0);
            hash = 89 * hash + (this.group.getDisplayName() != null ? this.group.getDisplayName().hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WebResourceGroup other = (WebResourceGroup)obj;
            if (!(this.project == other.project || this.project != null && this.project.equals((Object)other.project))) {
                return false;
            }
            if (!(this.group.getRootFolder() == other.group.getRootFolder() || this.group.getRootFolder() != null && this.group.getRootFolder().equals(other.group.getRootFolder()))) {
                return false;
            }
            if (this.group.getName() == null ? other.group.getName() != null : !this.group.getName().equals(other.group.getName())) {
                return false;
            }
            return !(this.group.getDisplayName() == null ? other.group.getDisplayName() != null : !this.group.getDisplayName().equals(other.group.getDisplayName()));
        }

        public FileObject getRootFolder() {
            return this.group.getRootFolder();
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return this.group.getDisplayName();
        }

        public Icon getIcon(boolean opened) {
            return this.group.getIcon(opened);
        }

        public boolean contains(FileObject file) {
            return this.group.contains(file);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.group.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.group.removePropertyChangeListener(listener);
        }
    }
}

