/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;

class JComboBoxValidationListenerImpl
extends ValidationListener<JComboBox>
implements EventListener,
ItemListener,
FocusListener {
    private Validator<ComboBoxModel> validator;
    private boolean hasFatalProblem = false;

    public JComboBoxValidationListenerImpl(JComboBox component, ValidationStrategy strategy, ValidationUI validationUI, Validator<ComboBoxModel> validator) {
        super(JComboBox.class, validationUI, component);
        this.validator = validator;
        if (strategy == null) {
            throw new NullPointerException("strategy null");
        }
        component.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JComboBoxValidationListenerImpl.this.performValidation();
            }
        });
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                component.addItemListener(this);
                break;
            }
            case ON_FOCUS_LOSS: {
                component.addFocusListener(this);
                break;
            }
            case INPUT_VERIFIER: {
                component.setInputVerifier(new InputVerifier(){

                    @Override
                    public boolean verify(JComponent input) {
                        JComboBoxValidationListenerImpl.this.performValidation();
                        return !JComboBoxValidationListenerImpl.this.hasFatalProblem;
                    }
                });
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.performValidation();
    }

    @Override
    protected void performValidation(Problems ps) {
        JComboBox component = (JComboBox)this.getTarget();
        if (!component.isEnabled()) {
            return;
        }
        this.validator.validate(ps, SwingValidationGroup.nameForComponent(component), component.getModel());
        this.hasFatalProblem = ps.hasFatal();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.performValidation();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.performValidation();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

