/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ant.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.junit.ant.ui.Bundle;
import org.netbeans.modules.junit.api.JUnitUtils;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class JUnitProjectOpenedHook
implements LookupProvider {
    private static final String JUNIT3_SPECIFIC = "junit/awtui/TestRunner.class";
    private static final String JUNIT4_SPECIFIC = "org/junit/Test.class";
    private static final String HAMCREST_SPECIFIC = "org/hamcrest/Matcher.class";
    public static final String ACT_START_MESSAGE = "START_MESSAGE";
    private static final String MISSING_JUNIT_BINARIES = "MISSINGJUNITBINARIES";
    private static final String PROP_JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    private static final RequestProcessor RP = new RequestProcessor(JUnitProjectProblemsProvider.class);
    private final WeakHashMap<Project, WeakReference<JUnitProjectProblemsProvider>> map = new WeakHashMap();

    public Lookup createAdditionalLookup(Lookup lookup) {
        final Project p = (Project)lookup.lookup(Project.class);
        this.map.put(p, new WeakReference<JUnitProjectProblemsProvider>(new JUnitProjectProblemsProvider()));
        ProjectOpenedHook projectOpenedHook = new ProjectOpenedHook(this){
            final /* synthetic */ JUnitProjectOpenedHook this$0;
            {
                this.this$0 = this$0;
            }

            protected void projectOpened() {
                ClassPath classPath = JUnitProjectOpenedHook.getTestClassPath(p);
                if (classPath != null) {
                    if (classPath.findResource(JUnitProjectOpenedHook.JUNIT3_SPECIFIC) != null || classPath.toString().contains("${libs.junit.classpath}")) {
                        this.this$0.getJUnitProjectProblemsProvider(p).setProblem(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Error_display_name_junit(), (String)Bundle.Error_description_junit(), (ProjectProblemResolver)this.this$0.new JUnitProblemResolver(this.this$0.new UpdateToJUnit4Action(p, true), JUnitProjectOpenedHook.MISSING_JUNIT_BINARIES)));
                    }
                    if (classPath.findResource(JUnitProjectOpenedHook.JUNIT4_SPECIFIC) != null && classPath.findResource(JUnitProjectOpenedHook.HAMCREST_SPECIFIC) == null) {
                        this.this$0.getJUnitProjectProblemsProvider(p).setProblem(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Error_display_name_junit4(), (String)Bundle.Error_description_junit4(), (ProjectProblemResolver)this.this$0.new JUnitProblemResolver(this.this$0.new UpdateToJUnit4Action(p, false), JUnitProjectOpenedHook.MISSING_JUNIT_BINARIES)));
                    }
                }
            }

            protected void projectClosed() {
                this.this$0.getJUnitProjectProblemsProvider(p).setProblem(null);
            }
        };
        return Lookups.fixed((Object[])new Object[]{projectOpenedHook, this.getJUnitProjectProblemsProvider(p)});
    }

    private JUnitProjectProblemsProvider getJUnitProjectProblemsProvider(Project p) {
        WeakReference<JUnitProjectProblemsProvider> problemsProviderRef = this.map.get(p);
        if (problemsProviderRef == null || problemsProviderRef.get() == null) {
            problemsProviderRef = new WeakReference<JUnitProjectProblemsProvider>(new JUnitProjectProblemsProvider());
            this.map.put(p, problemsProviderRef);
        }
        return (JUnitProjectProblemsProvider)problemsProviderRef.get();
    }

    private static ClassPath getTestClassPath(Project project) throws IllegalStateException {
        assert (project != null);
        Collection testFolders = JUnitUtils.getTestFolders((Project)project);
        ClassPathProvider cpProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (cpProvider == null) {
            return null;
        }
        for (FileObject testRoot : testFolders) {
            ClassPath testClassPath = cpProvider.findClassPath(testRoot, "classpath/compile");
            if (testClassPath == null) continue;
            return testClassPath;
        }
        return null;
    }

    private class JUnitProjectProblemsProvider
    implements ProjectProblemsProvider {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private ProjectProblemsProvider.ProjectProblem pp;

        synchronized void setProblem(ProjectProblemsProvider.ProjectProblem pp) {
            this.pp = pp;
            if (pp == null && this.pp == null) {
                return;
            }
            this.pcs.firePropertyChange("problems", null, null);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public synchronized Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
            if (this.pp != null) {
                return Collections.singleton(this.pp);
            }
            return Collections.emptyList();
        }
    }

    private class UpdateToJUnit4Action
    extends AbstractAction {
        private final Project p;
        private final boolean isJUnit3specific;

        UpdateToJUnit4Action(Project project, boolean isJUnit3specific) {
            this.putValue("Name", isJUnit3specific ? Bundle.Action_display_name_junit() : Bundle.Action_display_name_junit4());
            this.putValue(JUnitProjectOpenedHook.ACT_START_MESSAGE, isJUnit3specific ? Bundle.Action_start_msg_junit() : Bundle.Action_start_msg_junit4());
            this.p = project;
            this.isJUnit3specific = isJUnit3specific;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject buildXML = this.p.getProjectDirectory().getFileObject("build.xml");
            Library junit4lib = LibraryManager.getDefault().getLibrary("junit_4");
            Library hamcrestlib = LibraryManager.getDefault().getLibrary("hamcrest");
            if (buildXML != null) {
                try {
                    this.updateProjectProperties(this.p);
                    Collection testFolders = JUnitUtils.getTestFolders((Project)this.p);
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{junit4lib, hamcrestlib}, (FileObject)testFolders.toArray(new FileObject[0])[0], (String)"classpath/compile");
                    JUnitProjectOpenedHook.this.getJUnitProjectProblemsProvider(this.p).setProblem(null);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (UnsupportedOperationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private void updateProjectProperties(Project project) throws IOException {
            final FileObject projectDir = project.getProjectDirectory();
            ProjectManager.mutex().postWriteRequest(new Runnable(){
                final /* synthetic */ UpdateToJUnit4Action this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    try {
                        FileObject projectProperties = FileUtil.createData((FileObject)projectDir, (String)"nbproject/project.properties");
                        Properties props = this.this$1.getProjectProperties(projectDir);
                        if (this.this$1.isJUnit3specific) {
                            String testClasspath = props.getProperty(JUnitProjectOpenedHook.PROP_JAVAC_TEST_CLASSPATH);
                            props.put(JUnitProjectOpenedHook.PROP_JAVAC_TEST_CLASSPATH, testClasspath.replace("${libs.junit.classpath}", ""));
                        }
                        props.put("junit.selected.version", this.this$1.isJUnit3specific ? "3" : "4");
                        OutputStream propertiesOS = projectProperties.getOutputStream();
                        props.store(propertiesOS, null);
                        propertiesOS.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        private Properties getProjectProperties(FileObject projectDir) throws IOException {
            FileObject projectProperties = FileUtil.createData((FileObject)projectDir, (String)"nbproject/project.properties");
            InputStream propertiesIS = projectProperties.getInputStream();
            Properties props = new Properties();
            props.load(propertiesIS);
            propertiesIS.close();
            return props;
        }
    }

    private class JUnitProblemResolver
    implements ProjectProblemResolver {
        private final Action action;
        private final String id;

        public JUnitProblemResolver(Action correctiveAction, String id) {
            this.action = correctiveAction;
            this.id = id;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            ProjectProblemsProvider.Result res;
            if (this.action != null) {
                this.action.actionPerformed(null);
                String text = (String)this.action.getValue(JUnitProjectOpenedHook.ACT_START_MESSAGE);
                res = text != null ? ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)text) : ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
            } else {
                res = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)"No resolution for the problem");
            }
            FutureTask<ProjectProblemsProvider.Result> f = new FutureTask<ProjectProblemsProvider.Result>(new Runnable(){

                @Override
                public void run() {
                }
            }, res);
            f.run();
            return f;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JUnitProblemResolver other = (JUnitProblemResolver)obj;
            return !(this.id != null ? !this.id.equals(other.id) : other.id != null);
        }
    }
}

