/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;

public final class DependencyChangeException
extends Exception {
    private final Reason reason;
    private final DependencyChange request;
    private final Map<Dependency, Dependency> offendingDependencies;

    public DependencyChangeException(DependencyChange request, Dependency d, Reason r) {
        this.reason = r;
        this.request = request;
        this.offendingDependencies = new HashMap<Dependency, Dependency>();
        this.offendingDependencies.put(d, null);
    }

    public DependencyChangeException(DependencyChange request, Reason reason, Map<Dependency, Dependency> offendingDependencies) {
        this.reason = reason;
        this.request = request;
        this.offendingDependencies = Collections.unmodifiableMap(offendingDependencies);
    }

    public Reason getReason() {
        return this.reason;
    }

    public Collection<Dependency> getFailedDependencies() {
        return this.offendingDependencies.keySet();
    }

    public Dependency getConflictSource(Dependency failed) {
        return this.offendingDependencies.get(failed);
    }

    public static enum Reason {
        CONFLICT,
        MISSING,
        MALFORMED;

    }
}

