/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalContainerDatabaseRequest
extends BmcRequest<Void> {
    private String externalContainerDatabaseId;
    private String opcRequestId;

    public String getExternalContainerDatabaseId() {
        return this.externalContainerDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalContainerDatabaseId(this.externalContainerDatabaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalContainerDatabaseId=").append(String.valueOf(this.externalContainerDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalContainerDatabaseRequest)) {
            return false;
        }
        GetExternalContainerDatabaseRequest other = (GetExternalContainerDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalContainerDatabaseId, other.externalContainerDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalContainerDatabaseId == null ? 43 : this.externalContainerDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalContainerDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalContainerDatabaseId = null;
        private String opcRequestId = null;

        public Builder externalContainerDatabaseId(String externalContainerDatabaseId) {
            this.externalContainerDatabaseId = externalContainerDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalContainerDatabaseRequest o) {
            this.externalContainerDatabaseId(o.getExternalContainerDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalContainerDatabaseRequest build() {
            GetExternalContainerDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalContainerDatabaseRequest buildWithoutInvocationCallback() {
            GetExternalContainerDatabaseRequest request = new GetExternalContainerDatabaseRequest();
            request.externalContainerDatabaseId = this.externalContainerDatabaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

