/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.classfile.CodeGenerator;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.ui.ElementOpenAccessor;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ElementOpen {
    private static Logger log = Logger.getLogger(ElementOpen.class.getName());
    private static final int AWT_TIMEOUT = 1000;
    private static final int NON_AWT_TIMEOUT = 2000;

    private ElementOpen() {
    }

    public static boolean open(ClasspathInfo cpInfo, ElementHandle<? extends Element> el) {
        return ElementOpen.open(cpInfo, el, new String[0]);
    }

    public static boolean open(final ClasspathInfo cpInfo, final ElementHandle<? extends Element> el, final String ... names) {
        final AtomicBoolean cancel = new AtomicBoolean();
        if (SwingUtilities.isEventDispatchThread() && !JavaSourceAccessor.holdsParserLock()) {
            final Object[] openInfo = new Object[3];
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] info = ElementOpen.getOpenInfo(cpInfo, (ElementHandle<? extends Element>)el, names, cancel);
                    if (info != null) {
                        openInfo[0] = info[0];
                        openInfo[1] = info[1];
                        openInfo[2] = info[2];
                    }
                }
            }, (String)NbBundle.getMessage(ElementOpen.class, (String)"TXT_CalculatingDeclPos"), (AtomicBoolean)cancel, (boolean)false);
            if (cancel.get()) {
                return false;
            }
            if (openInfo[0] instanceof FileObject) {
                return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
            }
            return ElementOpen.binaryOpen(cpInfo, el, cancel);
        }
        return ElementOpen.open(cpInfo, el, names, cancel);
    }

    private static boolean open(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, String[] names, AtomicBoolean cancel) {
        Object[] openInfo = ElementOpen.getOpenInfo(cpInfo, el, names, cancel);
        if (cancel.get()) {
            return false;
        }
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
        }
        return ElementOpen.binaryOpen(cpInfo, el, cancel);
    }

    private static boolean binaryOpen(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, AtomicBoolean cancel) {
        BinaryElementOpen beo = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (beo != null) {
            return beo.open(cpInfo, el, cancel);
        }
        return false;
    }

    public static boolean open(ClasspathInfo cpInfo, Element el) {
        return ElementOpen.open(cpInfo, (ElementHandle<? extends Element>)ElementHandle.create((Element)el));
    }

    public static boolean open(final @NonNull FileObject toSearch, final @NonNull ElementHandle<? extends Element> toOpen) {
        final AtomicBoolean cancel = new AtomicBoolean();
        if (SwingUtilities.isEventDispatchThread() && !JavaSourceAccessor.holdsParserLock()) {
            final Object[] openInfo = new Object[3];
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] info;
                    Object[] objectArray = info = !ElementOpen.isClassFile(toSearch) ? ElementOpen.getOpenInfo(toSearch, (ElementHandle<? extends Element>)toOpen, cancel) : null;
                    if (info != null) {
                        openInfo[0] = info[0];
                        openInfo[1] = info[1];
                        openInfo[2] = info[2];
                    }
                }
            }, (String)NbBundle.getMessage(ElementOpen.class, (String)"TXT_CalculatingDeclPos"), (AtomicBoolean)cancel, (boolean)false);
            if (cancel.get()) {
                return false;
            }
            if (openInfo[0] instanceof FileObject) {
                return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
            }
            return ElementOpen.binaryOpen(toSearch, toOpen, cancel);
        }
        return ElementOpen.open(toSearch, toOpen, cancel);
    }

    private static boolean open(@NonNull FileObject toSearch, @NonNull ElementHandle<? extends Element> toOpen, @NonNull AtomicBoolean cancel) {
        Object[] openInfo;
        Parameters.notNull((CharSequence)"toSearch", (Object)toSearch);
        Parameters.notNull((CharSequence)"toOpen", toOpen);
        Object[] objectArray = openInfo = !ElementOpen.isClassFile(toSearch) ? ElementOpen.getOpenInfo(toSearch, toOpen, cancel) : null;
        if (cancel.get()) {
            return false;
        }
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
        }
        return ElementOpen.binaryOpen(toSearch, toOpen, cancel);
    }

    private static boolean binaryOpen(@NonNull FileObject toSearch, @NonNull ElementHandle<? extends Element> toOpen, @NonNull AtomicBoolean cancel) {
        boolean res = false;
        BinaryElementOpen beo = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (beo != null) {
            ClassPath cp;
            ClassPath bootCp = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/boot");
            if (bootCp == null) {
                bootCp = JavaPlatform.getDefault().getBootstrapLibraries();
            }
            if (((cp = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/compile")) == null || cp.findOwnerRoot(toSearch) == null) && (cp = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/execute")) == null) {
                cp = ClassPath.EMPTY;
            }
            ClassPath src = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/source");
            res = beo.open(ClasspathInfo.create((ClassPath)bootCp, (ClassPath)cp, (ClassPath)src), toOpen, cancel);
        }
        return res;
    }

    public static boolean open(final @NonNull FileObject toSearch, final @NonNull TreePathHandle toOpen) {
        final AtomicBoolean cancel = new AtomicBoolean();
        if (SwingUtilities.isEventDispatchThread() && !JavaSourceAccessor.holdsParserLock()) {
            final boolean[] result = new boolean[1];
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    result[0] = ElementOpen.open(toSearch, toOpen, cancel);
                }
            }, (String)NbBundle.getMessage(ElementOpen.class, (String)"TXT_CalculatingDeclPos"), (AtomicBoolean)cancel, (boolean)false);
            return result[0];
        }
        return ElementOpen.open(toSearch, toOpen, cancel);
    }

    private static boolean open(@NonNull FileObject toSearch, final @NonNull TreePathHandle toOpen, final @NonNull AtomicBoolean cancel) {
        Parameters.notNull((CharSequence)"toSearch", (Object)toSearch);
        Parameters.notNull((CharSequence)"toOpen", (Object)toOpen);
        try {
            final long[] pos = new long[]{-1L, -1L};
            JavaSource js = JavaSource.forFileObject((FileObject)toSearch);
            if (js != null) {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        if (cancel.get()) {
                            return;
                        }
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath tp = toOpen.resolve((CompilationInfo)cc);
                        if (tp != null) {
                            SourcePositions sourcePos = cc.getTrees().getSourcePositions();
                            pos[0] = sourcePos.getStartPosition(cc.getCompilationUnit(), tp.getLeaf());
                            pos[1] = sourcePos.getEndPosition(cc.getCompilationUnit(), tp.getLeaf());
                        }
                    }
                }, true);
            }
            return cancel.get() ? false : ElementOpen.doOpen(toSearch, (int)pos[0], (int)pos[1]);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
    }

    public static CompletableFuture<Location> getLocation(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, String resourceName) {
        return ElementOpen.getLocation(cpInfo, el, resourceName, new String[0]);
    }

    public static CompletableFuture<Location> getLocation(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, String resourceName, String ... names) {
        CompletableFuture<Object[]> future = ElementOpen.getFutureOpenInfo(cpInfo, el, resourceName, new AtomicBoolean(), true, names);
        return future.thenApply(openInfo -> {
            if (openInfo != null && openInfo[0] != null) {
                int end;
                FileObject file = (FileObject)openInfo[0];
                int start = (Integer)openInfo[3];
                if (start < 0) {
                    start = Math.max(0, (Integer)openInfo[1]);
                }
                if ((end = ((Integer)openInfo[4]).intValue()) < 0) {
                    end = Math.max(0, (Integer)openInfo[2]);
                }
                return new Location(file, start, end);
            }
            return null;
        });
    }

    private static boolean isClassFile(@NonNull FileObject file) {
        return "class".equals(file.getExt()) || "application/x-class-file".equals(file.getMIMEType(new String[]{"application/x-class-file"}));
    }

    static CompletableFuture<Object[]> getFutureOpenInfo(final ClasspathInfo cpInfo, final ElementHandle<? extends Element> el, String resourceName, final AtomicBoolean cancel, boolean acquire, String ... names) {
        FileObject root;
        ClassPath cp;
        FileObject resource;
        Object[] openInfo = ElementOpen.getOpenInfo(cpInfo, el, names, cancel);
        if (openInfo != null) {
            return CompletableFuture.completedFuture(openInfo);
        }
        if (resourceName != null && acquire && (resource = (cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)})).findResource(resourceName)) != null && (root = cp.findOwnerRoot(resource)) != null) {
            final CompletableFuture<Object[]> future = new CompletableFuture<Object[]>();
            try {
                SourceJavadocAttacher.attachSources((URL)root.toURL(), (SourceJavadocAttacher.AttachmentListener)new SourceJavadocAttacher.AttachmentListener(){

                    public void attachmentSucceeded() {
                        try {
                            Object[] openInfo = ElementOpen.getOpenInfo(cpInfo, (ElementHandle<? extends Element>)el, null, cancel);
                            if (openInfo != null && (Integer)openInfo[1] != -1 && (Integer)openInfo[2] != -1 && openInfo[5] != null) {
                                future.complete(openInfo);
                            } else {
                                this.attachmentFailed();
                            }
                        }
                        catch (Throwable t) {
                            future.completeExceptionally(t);
                        }
                    }

                    public void attachmentFailed() {
                        try {
                            FileObject generated = CodeGenerator.generateCode((ClasspathInfo)cpInfo, (ElementHandle)el, (boolean[])new boolean[1]);
                            future.complete(generated != null ? ElementOpen.getOpenInfo(generated, (ElementHandle<? extends Element>)el, cancel) : null);
                        }
                        catch (Throwable t) {
                            future.completeExceptionally(t);
                        }
                    }
                });
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
            return future;
        }
        FileObject generated = CodeGenerator.generateCode((ClasspathInfo)cpInfo, el, (boolean[])new boolean[1]);
        return CompletableFuture.completedFuture(generated != null ? ElementOpen.getOpenInfo(generated, el, cancel) : null);
    }

    static Object[] getOpenInfo(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, String[] names, AtomicBoolean cancel) {
        FileObject fo = SourceUtils.getFile(el, (ClasspathInfo)cpInfo, (String[])names);
        if (fo != null && fo.isFolder()) {
            fo = fo.getFileObject("package-info.java");
        }
        return fo != null ? ElementOpen.getOpenInfo(fo, el, cancel) : null;
    }

    private static Object[] getOpenInfo(FileObject fo, ElementHandle<? extends Element> handle, AtomicBoolean cancel) {
        assert (fo != null);
        try {
            Object[] result = new Object[7];
            result[0] = fo;
            ElementOpen.getOffset(fo, handle, result, cancel);
            return result;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static boolean doOpen(FileObject fo, final int offsetA, final int offsetB) {
        DataObject od;
        boolean success;
        if (offsetA == -1) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ElementOpen.class, (String)"WARN_ElementNotFound"), 1000);
        }
        if (!(success = UiUtils.open((FileObject)fo, (int)offsetA))) {
            return false;
        }
        try {
            od = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return success;
        }
        final EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
        if (ec != null && offsetA != -1 && offsetB != -1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane pane;
                    FoldHierarchy fh;
                    Fold f;
                    JEditorPane[] panes = ec.getOpenedPanes();
                    if (offsetB >= 0 && panes != null && panes.length > 0 && (f = FoldUtilities.findNearestFold((FoldHierarchy)(fh = FoldHierarchy.get((JTextComponent)(pane = panes[0]))), (int)offsetA)) != null && f.getStartOffset() >= offsetA && f.getEndOffset() <= offsetB) {
                        fh.expand(f);
                    }
                }
            });
        }
        return success;
    }

    private static void getOffset(final FileObject fo, final ElementHandle<? extends Element> handle, final Object[] result, final AtomicBoolean cancel) throws IOException {
        result[1] = -1;
        result[2] = -1;
        result[3] = -1;
        result[4] = -1;
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            Task<CompilationController> t = new Task<CompilationController>(){

                public void run(CompilationController info) throws IOException {
                    if (cancel.get()) {
                        return;
                    }
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    result[5] = info.getCompilationUnit().getLineMap();
                    Element el = handle.resolve((CompilationInfo)info);
                    if (el == null) {
                        if (!SourceUtils.isScanInProgress()) {
                            log.severe("Cannot resolve " + String.valueOf(handle) + ". " + String.valueOf(info.getClasspathInfo()));
                        } else {
                            Level l = Level.FINE;
                            assert ((l = Level.INFO) != null);
                            log.log(l, "Cannot resolve {0} ({1})", new Object[]{handle, info.getClasspathInfo()});
                        }
                        return;
                    }
                    if (el.getKind() == ElementKind.PACKAGE) {
                        Matcher m = Pattern.compile("(?m)^package (.+);$").matcher(fo.asText());
                        if (m.find()) {
                            result[1] = m.start();
                        }
                        return;
                    }
                    result[6] = TreePathHandle.create((Element)el, (CompilationInfo)info);
                    FindDeclarationVisitor v = new FindDeclarationVisitor(el, (CompilationInfo)info);
                    CompilationUnitTree cu = info.getCompilationUnit();
                    v.scan(cu, null);
                    Tree elTree = v.declTree;
                    if (elTree == null) {
                        elTree = info.getTrees().getTree(el);
                    }
                    if (elTree != null) {
                        ElementOpen.fillInTreePositions((CompilationInfo)info, elTree, result);
                    }
                }
            };
            js.runUserActionTask((Task)t, true);
        }
    }

    static void fillInTreePositions(CompilationInfo info, Tree forTree, Object[] target) {
        CompilationUnitTree cu = info.getCompilationUnit();
        target[1] = (int)info.getTrees().getSourcePositions().getStartPosition(cu, forTree);
        target[2] = (int)info.getTrees().getSourcePositions().getEndPosition(cu, forTree);
        int[] span = null;
        switch (forTree.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case RECORD: {
                span = info.getTreeUtilities().findNameSpan((ClassTree)forTree);
                break;
            }
            case METHOD: {
                span = info.getTreeUtilities().findNameSpan((MethodTree)forTree);
                break;
            }
            case VARIABLE: {
                span = info.getTreeUtilities().findNameSpan((VariableTree)forTree);
            }
        }
        if (span != null) {
            target[3] = span[0];
            target[4] = span[1];
        }
    }

    static {
        ElementOpenAccessor.setInstance(new ElementOpenAccessor(){

            @Override
            public Object[] getOpenInfo(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, AtomicBoolean cancel) {
                return ElementOpen.getOpenInfo(cpInfo, el, null, cancel);
            }

            @Override
            public void fillInTreePositions(CompilationInfo info, Tree forTree, Object[] target) {
                ElementOpen.fillInTreePositions(info, forTree, target);
            }

            @Override
            public CompletableFuture<Object[]> getOpenInfoFuture(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, String nameOpt, AtomicBoolean cancel, boolean acquire) {
                return ElementOpen.getFutureOpenInfo(cpInfo, el, nameOpt, cancel, acquire, new String[0]);
            }
        });
    }

    public static final class Location {
        private final FileObject fileObject;
        private final int startOffset;
        private final int endOffset;

        private Location(FileObject fileObject, int startOffset, int endOffset) {
            this.fileObject = fileObject;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    private static class FindDeclarationVisitor
    extends ErrorAwareTreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo info) {
            this.element = element;
            this.info = info;
        }

        public Void visitClass(ClassTree tree, Void d) {
            this.handleDeclaration();
            super.visitClass(tree, (Object)d);
            return null;
        }

        public Void visitMethod(MethodTree tree, Void d) {
            this.handleDeclaration();
            super.visitMethod(tree, (Object)d);
            return null;
        }

        public Void visitVariable(VariableTree tree, Void d) {
            this.handleDeclaration();
            super.visitVariable(tree, (Object)d);
            return null;
        }

        public Void visitModule(ModuleTree node, Void p) {
            this.handleDeclaration();
            super.visitModule(node, (Object)p);
            return null;
        }

        public void handleDeclaration() {
            Element found = this.info.getTrees().getElement(this.getCurrentPath());
            if (this.element.equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

